/*
 * Decompiled with CFR 0.152.
 */
package abscon;

import XSax.Problem0;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.xml.XMLManipulation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChallengerResolution {
    private File srcDirectory;
    private String command;
    private String defaultConfigurationFileName;
    private String currentConfigurationFileName;
    private String selectedInstancesFileName;
    private String configurationVariantsFileName;
    private String directoryNameOfConfigurationFiles;
    private String directoryNameOfLogs;
    private String mode = "all";
    private PrintWriter out;
    private int nbSolved;
    private int nbUnsolved;
    private boolean officialCompetition = false;

    private String getOutputFileName() {
        String hostName = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            hostName = "unknown";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        DecimalFormat df = new DecimalFormat("00");
        return String.valueOf(this.directoryNameOfLogs) + File.separator + "challenger_" + Tools.getXMLBaseNameOf(this.currentConfigurationFileName) + "_" + hostName + "_" + year + "_" + df.format(month) + "_" + df.format(day) + "_" + df.format(hour) + "_" + df.format(minute) + ".txt";
    }

    public ChallengerResolution(String command, String defaultConfigurationFileName, String selectedInstancesFileName, String configurationVariantsFileName) {
        String jarName;
        String directoryNameOfContext;
        this.command = command;
        this.defaultConfigurationFileName = defaultConfigurationFileName;
        this.selectedInstancesFileName = selectedInstancesFileName;
        this.configurationVariantsFileName = configurationVariantsFileName;
        ConfigurationManager.loadConfigurationFile(defaultConfigurationFileName);
        String directoryName = ConfigurationManager.getString("//saveXMLOutputs", "dir");
        if (directoryName.trim().equals("")) {
            throw new IncompatiblePropertiesException();
        }
        this.directoryNameOfConfigurationFiles = String.valueOf(directoryName) + File.separator + "configurations";
        File file = new File(this.directoryNameOfConfigurationFiles);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.directoryNameOfLogs = String.valueOf(directoryName) + File.separator + "logs";
        file = new File(this.directoryNameOfLogs);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(directoryNameOfContext = String.valueOf(directoryName) + File.separator + "context")).exists()) {
            file.mkdirs();
        }
        Tools.copy(defaultConfigurationFileName, String.valueOf(directoryNameOfContext) + File.separator + defaultConfigurationFileName);
        Tools.copy(selectedInstancesFileName, String.valueOf(directoryNameOfContext) + File.separator + selectedInstancesFileName);
        if (configurationVariantsFileName != null) {
            Tools.copy(configurationVariantsFileName, String.valueOf(directoryNameOfContext) + File.separator + configurationVariantsFileName);
        }
        if ((jarName = System.getProperty("java.class.path")).indexOf(File.pathSeparator) == -1 && jarName.endsWith(".jar")) {
            int position = jarName.lastIndexOf(File.separator);
            position = position == -1 ? 0 : position + 1;
            Tools.copy(jarName, String.valueOf(directoryNameOfContext) + File.separator + jarName.substring(position));
        }
    }

    private boolean mustBeTreated(File file) {
        String fileName = file.getName().toLowerCase();
        if (!fileName.toLowerCase().endsWith("xml")) {
            return false;
        }
        String dir = file.getParentFile().getName();
        if (this.mode.equals("all")) {
            return true;
        }
        return dir.equals(this.mode);
    }

    private void checkStatus(int status, String line) {
        boolean invalid = status == 0 && !line.equals("SAT") && !line.equals("UNSAT");
        boolean bl = invalid = invalid && status != 0 && !line.startsWith("UNKNOWN");
        if (invalid) {
            System.out.println(" status invalid");
            System.exit(1);
        }
    }

    private void treat(String completeCommand) {
        System.out.println("command = " + completeCommand);
        try {
            String firstLine;
            Process p = Runtime.getRuntime().exec(completeCommand);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = firstLine = in.readLine();
            while (line != null) {
                this.out.println(line);
                line = in.readLine();
            }
            in.close();
            p.waitFor();
            int status = p.exitValue();
            p.destroy();
            if (this.officialCompetition) {
                this.checkStatus(status, firstLine);
            }
            if (status == 0) {
                ++this.nbSolved;
            } else {
                ++this.nbUnsolved;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.out.flush();
    }

    private void operateFile(File srcFile) {
        if (!this.mustBeTreated(srcFile)) {
            return;
        }
        this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " 1 " + Tools.getRelativeParentPackageNameOf(Problem0.class) + " y " + srcFile.toString());
    }

    private void operateDirectory(File dir) {
        int nbLocalSolved = this.nbSolved;
        int nbLocalUnsolved = this.nbUnsolved;
        Object[] list = dir.list();
        Arrays.sort(list);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < list.length) {
            this.operate(new File(dir, (String)list[i]));
            ++i;
        }
        long stop = System.currentTimeMillis();
        this.out.println("stats dir = " + dir + " totalTime = " + (stop - start) + " nbSolved = " + (this.nbSolved - nbLocalSolved) + " nbUnsolved = " + (this.nbUnsolved - nbLocalUnsolved));
        this.out.flush();
    }

    private void operate(File file) {
        if (!file.isDirectory()) {
            this.operateFile(file);
        } else {
            this.operateDirectory(file);
        }
    }

    public void runSingle() {
        try {
            this.out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.getOutputFileName())), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Document document = XMLManipulation.load(this.selectedInstancesFileName);
        if (document == null) {
            throw new IllegalArgumentException("Unloaded document");
        }
        NodeList directoryList = document.getElementsByTagName("directory");
        int i = 0;
        while (i < directoryList.getLength()) {
            Element element = (Element)directoryList.item(i);
            String value = element.getAttribute("value");
            this.srcDirectory = new File(value);
            this.operate(this.srcDirectory);
            ++i;
        }
        if (directoryList.getLength() > 0) {
            this.out.println("stats all selected directories : nbSolved = " + this.nbSolved + " nbUnsolved = " + this.nbUnsolved);
        }
        NodeList parametersList = document.getElementsByTagName("parameters");
        int i2 = 0;
        while (i2 < parametersList.getLength()) {
            Element element = (Element)parametersList.item(i2);
            String nbInstances = element.getAttribute("nbInstances");
            String packageName = element.getAttribute("package");
            String value = element.getAttribute("value");
            if (value.indexOf("?") == -1) {
                this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " " + nbInstances + " " + packageName + " " + value);
            } else {
                double min = Double.parseDouble(element.getAttribute("min"));
                double max = Double.parseDouble(element.getAttribute("max"));
                double step = Double.parseDouble(element.getAttribute("step"));
                double d = min;
                while (d <= max) {
                    String val = value.replace("?", String.valueOf(d));
                    this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " " + nbInstances + " " + packageName + " " + val);
                    d += step;
                }
            }
            ++i2;
        }
        this.out.close();
    }

    private void modify(Document document, String path, String attributeName, String attributeValue) {
        Element element = (Element)document.getElementsByTagName("configuration").item(0);
        while (path.indexOf("/") != -1) {
            int position = path.indexOf("/");
            String s = path.substring(0, position);
            path = path.substring(position + 1);
            element = (Element)document.getElementsByTagName(s).item(0);
        }
        element = (Element)document.getElementsByTagName(path).item(0);
        element.setAttribute(attributeName, attributeValue);
    }

    public void run() {
        if (this.configurationVariantsFileName == null) {
            Tools.copy(this.defaultConfigurationFileName, String.valueOf(this.directoryNameOfConfigurationFiles) + File.separator + this.defaultConfigurationFileName);
            this.currentConfigurationFileName = String.valueOf(this.directoryNameOfConfigurationFiles) + File.separator + this.defaultConfigurationFileName;
            this.runSingle();
        } else {
            Document variantsDocument = XMLManipulation.load(this.configurationVariantsFileName);
            if (variantsDocument == null) {
                throw new IllegalArgumentException("Unloaded document");
            }
            NodeList variantList = variantsDocument.getElementsByTagName("variant");
            int i = 0;
            while (i < variantList.getLength()) {
                Document document = XMLManipulation.load(this.defaultConfigurationFileName);
                if (document == null) {
                    throw new IllegalArgumentException("Unloaded document");
                }
                Element variantElement = (Element)variantList.item(i);
                this.currentConfigurationFileName = String.valueOf(this.directoryNameOfConfigurationFiles) + File.separator + variantElement.getAttribute("name");
                NodeList modificationList = variantElement.getElementsByTagName("modification");
                int j = 0;
                while (j < modificationList.getLength()) {
                    Element modificationElement = (Element)modificationList.item(j);
                    String path = modificationElement.getAttribute("path");
                    String attributeName = modificationElement.getAttribute("attribute");
                    String attributeValue = modificationElement.getAttribute("value");
                    this.modify(document, path, attributeName, attributeValue);
                    ++j;
                }
                XMLManipulation.save(document, this.currentConfigurationFileName);
                this.runSingle();
                ++i;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 && args.length != 4) {
            System.out.println("Usage 1: java abscon.ChallengerResolution <command> <configurationFileName> <selectedInstancesFileName>");
            System.out.println("Usage 1: java abscon.ChallengerResolution <command> <defaultConfigurationFileName> <selectedInstancesFileName> <configurationVariantsFileName>");
            System.exit(1);
        }
        ChallengerResolution challenger = new ChallengerResolution(args[0], args[1], args[2], args.length == 3 ? null : args[3]);
        challenger.run();
    }
}

