/*
 * Decompiled with CFR 0.152.
 */
package abscon;

import XSax.Problem0;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.xml.OutputManager;
import abscon.xml.XMLManipulation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChallengerCluster {
    private File srcDirectory;
    private String command;
    private String defaultConfigurationFileName;
    private String currentConfigurationFileName;
    private String selectedInstancesFileName;
    private String configurationVariantsFileName;
    private String directoryNameOfConfigurations;
    private String directoryNameOfResults;
    private int queueMode;
    private String[] fileNameListOfResultsDirectory;
    private int nbVariants;
    private int nbLaunchedJobs;
    private static String[] args;
    private static final String suffixCommand = ",nodes=1:ppn=1 -m n -- ";
    private static final String[] queueCommands;

    static {
        queueCommands = new String[]{"qadd -q short -l cput=00:30:00,nodes=1:ppn=1 -m n -- ", "qadd -q normal -l cput=05:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q long -l cput=48:00:00,nodes=1:ppn=1 -m n -- "};
    }

    public ChallengerCluster(String command, String defaultConfigurationFileName, String selectedInstancesFileName, String configurationVariantsFileName, int queueMode) {
        String jarName;
        String directoryNameOfContext;
        this.command = command;
        this.defaultConfigurationFileName = defaultConfigurationFileName;
        this.selectedInstancesFileName = selectedInstancesFileName;
        this.configurationVariantsFileName = configurationVariantsFileName;
        this.queueMode = queueMode;
        ConfigurationManager.loadConfigurationFile(defaultConfigurationFileName);
        String directoryName = ConfigurationManager.getString("//saveXMLOutputs", "dir");
        if (directoryName.trim().equals("")) {
            throw new IncompatiblePropertiesException();
        }
        this.directoryNameOfConfigurations = String.valueOf(directoryName) + File.separator + "configurations";
        File file = new File(this.directoryNameOfConfigurations);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(directoryNameOfContext = String.valueOf(directoryName) + File.separator + "context")).exists()) {
            file.mkdirs();
        }
        this.directoryNameOfResults = String.valueOf(directoryName) + File.separator + "results";
        file = new File(this.directoryNameOfResults);
        if (!file.exists()) {
            file.mkdirs();
        }
        Tools.copy(defaultConfigurationFileName, String.valueOf(directoryNameOfContext) + File.separator + defaultConfigurationFileName);
        Tools.copy(selectedInstancesFileName, String.valueOf(directoryNameOfContext) + File.separator + selectedInstancesFileName);
        if (configurationVariantsFileName != null) {
            Tools.copy(configurationVariantsFileName, String.valueOf(directoryNameOfContext) + File.separator + configurationVariantsFileName);
        }
        if ((jarName = System.getProperty("java.class.path")).indexOf(File.pathSeparator) == -1 && jarName.endsWith(".jar")) {
            int position = jarName.lastIndexOf(File.separator);
            position = position == -1 ? 0 : position + 1;
            Tools.copy(jarName, String.valueOf(directoryNameOfContext) + File.separator + jarName.substring(position));
        }
    }

    private String getInstanceFileNameIfXMLProblem(String command) {
        StringTokenizer st = new StringTokenizer(command);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals(Tools.getRelativeParentPackageNameOf(Problem0.class))) continue;
            return st.nextToken();
        }
        return null;
    }

    private void treat(String command) {
        String fullInstanceFileName = this.getInstanceFileNameIfXMLProblem(command);
        if (fullInstanceFileName != null) {
            int position;
            String prefix = OutputManager.getFileNamePrefix(fullInstanceFileName, this.currentConfigurationFileName);
            if (this.fileNameListOfResultsDirectory == null) {
                File dir = new File(this.directoryNameOfResults);
                this.fileNameListOfResultsDirectory = dir.list();
                Arrays.sort(this.fileNameListOfResultsDirectory);
            }
            if ((position = Arrays.binarySearch(this.fileNameListOfResultsDirectory, prefix)) > 0) {
                System.out.println(" strange");
            }
            if ((position = -position - 1) < this.fileNameListOfResultsDirectory.length && this.fileNameListOfResultsDirectory[position].startsWith(prefix)) {
                return;
            }
        }
        ++this.nbLaunchedJobs;
        String completeCommand = String.valueOf(queueCommands[this.queueMode]) + command;
        System.out.println("Job number " + this.nbLaunchedJobs + " : " + completeCommand);
        try {
            Process p = Runtime.getRuntime().exec(completeCommand);
            p.waitFor();
            p.exitValue();
            p.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void operateFile(File srcFile) {
        this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " 1 " + Tools.getRelativeParentPackageNameOf(Problem0.class) + " " + srcFile.toString());
    }

    private void operateDirectory(File dir, String[] selectedInstances) {
        Object[] list = dir.list();
        if (list == null) {
            System.out.println("pb with " + dir);
            return;
        }
        Arrays.sort(list);
        int i = 0;
        while (i < list.length) {
            this.operate(new File(dir, (String)list[i]), selectedInstances);
            ++i;
        }
    }

    private void operate(File file, String[] selectedInstances) {
        if (file.isDirectory()) {
            this.operateDirectory(file, selectedInstances);
        } else {
            if (!file.getName().toLowerCase().endsWith("xml")) {
                return;
            }
            if (selectedInstances != null && Arrays.binarySearch(selectedInstances, file.getName()) < 0) {
                return;
            }
            this.operateFile(file);
        }
    }

    private String[] getSelectedInstances(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        try {
            LinkedList<String> list = new LinkedList<String>();
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                list.add(line.trim());
                line = in.readLine();
            }
            Object[] selectedInstances = list.toArray(new String[list.size()]);
            Arrays.sort(selectedInstances);
            return selectedInstances;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public void runWrtCurrentConfigurationFile() {
        Document document = XMLManipulation.load(this.selectedInstancesFileName);
        if (document == null) {
            throw new IllegalArgumentException("Unloaded document");
        }
        NodeList directoryList = document.getElementsByTagName("directory");
        int i = 0;
        while (i < directoryList.getLength()) {
            Element element = (Element)directoryList.item(i);
            String value = element.getAttribute("value");
            String[] selectedInstances = this.getSelectedInstances(element.getAttribute("restriction"));
            this.srcDirectory = new File(value);
            this.operate(this.srcDirectory, selectedInstances);
            ++i;
        }
        NodeList parametersList = document.getElementsByTagName("parameters");
        int i2 = 0;
        while (i2 < parametersList.getLength()) {
            Element element = (Element)parametersList.item(i2);
            String nbInstances = element.getAttribute("nbInstances");
            String packageName = element.getAttribute("package");
            String value = element.getAttribute("value");
            if (value.indexOf("?") == -1) {
                this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " " + nbInstances + " " + packageName + " " + value);
            } else {
                double min = Double.parseDouble(element.getAttribute("min"));
                double max = Double.parseDouble(element.getAttribute("max"));
                double step = Double.parseDouble(element.getAttribute("step"));
                double d = min;
                while (d <= max) {
                    this.treat(String.valueOf(this.command) + " " + this.currentConfigurationFileName + " " + nbInstances + " " + packageName + " " + value.replace("?", String.valueOf(d)));
                    d += step;
                }
            }
            ++i2;
        }
    }

    private void modify(Document document, String path, String attributeName, String attributeValue) {
        Element element = (Element)document.getElementsByTagName("configuration").item(0);
        while (path.indexOf("/") != -1) {
            int position = path.indexOf("/");
            String s = path.substring(0, position);
            path = path.substring(position + 1);
            element = (Element)document.getElementsByTagName(s).item(0);
        }
        element = (Element)document.getElementsByTagName(path).item(0);
        element.setAttribute(attributeName, attributeValue);
    }

    public void run() {
        if (this.configurationVariantsFileName == null) {
            this.nbVariants = 1;
            Tools.copy(this.defaultConfigurationFileName, String.valueOf(this.directoryNameOfConfigurations) + File.separator + this.defaultConfigurationFileName);
            this.currentConfigurationFileName = String.valueOf(this.directoryNameOfConfigurations) + File.separator + this.defaultConfigurationFileName;
            this.runWrtCurrentConfigurationFile();
        } else {
            Document variantsDocument = XMLManipulation.load(this.configurationVariantsFileName);
            if (variantsDocument == null) {
                throw new IllegalArgumentException("Unloaded document");
            }
            NodeList variantList = variantsDocument.getElementsByTagName("variant");
            int i = 0;
            while (i < variantList.getLength()) {
                Document document = XMLManipulation.load(this.defaultConfigurationFileName);
                if (document == null) {
                    throw new IllegalArgumentException("Unloaded document");
                }
                Element variantElement = (Element)variantList.item(i);
                this.currentConfigurationFileName = String.valueOf(this.directoryNameOfConfigurations) + File.separator + variantElement.getAttribute("name");
                NodeList modificationList = variantElement.getElementsByTagName("modification");
                int j = 0;
                while (j < modificationList.getLength()) {
                    Element modificationElement = (Element)modificationList.item(j);
                    String path = modificationElement.getAttribute("path");
                    String attributeName = modificationElement.getAttribute("attribute");
                    String attributeValue = modificationElement.getAttribute("value");
                    this.modify(document, path, attributeName, attributeValue);
                    ++j;
                }
                XMLManipulation.save(document, this.currentConfigurationFileName);
                this.runWrtCurrentConfigurationFile();
                ++i;
            }
            this.nbVariants = variantList.getLength();
        }
        String directoryName = ConfigurationManager.getString("//saveXMLOutputs", "dir");
        File file = new File(String.valueOf(directoryName) + File.separator + "synthesis.txt");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            out.println("----------------------");
            out.println("  Current time : " + Tools.getFormattedCurrentDate());
            out.println("  Command : java abscon.ChallengerCluster " + args[0] + " " + args[1] + " " + args[2] + " " + args[3] + " " + queueCommands[Integer.parseInt(args[4])]);
            out.println("  Nb Variants : " + this.nbVariants);
            out.println("  Nb Launched Jobs : " + this.nbLaunchedJobs);
            out.println();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(" => " + this.nbLaunchedJobs + " jobs launched");
    }

    public static void main(String[] args) throws Exception {
        ChallengerCluster.args = args;
        if (args.length != 5) {
            System.out.println("Usage : java abscon.ChallengerCluster <command> <defaultConfigurationFileName> <selectedInstancesFileName> <configurationVariantsFileName> <queueMode>");
            System.out.println();
            System.out.println("  Queue mode:");
            System.out.println("   - queue = 0 = short");
            System.out.println("   - queue = 1 = normal");
            System.out.println("   - queue = 2 = long");
            System.out.println();
            System.out.println("  NB: set no to <configurationVariantsFileName> to not take into account variants");
            System.exit(1);
        }
        String configurationVariantsFileName = args[3].trim().toLowerCase().equals("no") ? null : args[3];
        int queueMode = Integer.parseInt(args[4]);
        if (queueMode < 0 || queueMode > 2) {
            System.out.println("The queue mode must be set to 0 (short), 1 (normal) or 2 (long)");
            System.exit(1);
        }
        ChallengerCluster challenger = new ChallengerCluster(args[0], args[1], args[2], configurationVariantsFileName, queueMode);
        challenger.run();
    }
}

