/*
 * Decompiled with CFR 0.152.
 */
package XSax;

import XSax.InstanceHandler;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.problem.Problem;
import abscon.tools.IParameters;
import abscon.tools.absconParameters.ArgumentsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Problem0
extends Problem {
    private static List<String> instanceFilenames;

    @Override
    public String getName() {
        return "XML Problem 2.0 Sax";
    }

    @Override
    public String getDescription() {
        return "XML Problem 2.0 Sax";
    }

    @Override
    public String getInstanceName() {
        return ((Parameters)this.parameters).instanceFileName;
    }

    public static void clearInstanceFileNames() {
        instanceFilenames = null;
    }

    private static boolean operateDirectory(File dir) {
        File f;
        Object[] list = dir.list();
        Arrays.sort(list);
        int i = 0;
        while (i < list.length) {
            f = new File(dir, (String)list[i]);
            if (f.isFile() && f.getName().endsWith(".xml")) {
                instanceFilenames.add(f.getAbsolutePath());
                if (instanceFilenames.size() >= ArgumentsManager.getNbInstances()) {
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < list.length) {
            f = new File(dir, (String)list[i]);
            if (f.isDirectory() && Problem0.operateDirectory(f)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> loadInstanceFilenames() {
        instanceFilenames = new ArrayList<String>();
        String msg = "Enter the name of a XML file, the name of a directory or a boolean (y/n) if you want to use the multimode : ";
        String first = ArgumentsManager.getParameter("First", msg);
        String s = first.toLowerCase();
        if (s.equals("yes") || s.equals("y") || s.equals("1")) {
            String filename = ArgumentsManager.getParameter("Name ", "Name of the XML file : ");
            instanceFilenames.add(filename);
            return instanceFilenames;
        }
        if (s.equals("no") || s.equals("n") || s.equals("0")) {
            s = "As you can run several instances with abscon, you have to enter three parameters: first, the prefix of the instance series, second, the number of the instances, and third, the suffix of the instance series.\nFor instance,assume that you have a series of problem instances called:\n\t problem0.xml \n\t problem1.xml \n\t...\n\t problem99.xml \nthat are put in ../problems/ wrt the current directory where you are going to run abscon then you have to enter ../problems/problem as first argument, 5 as second argument if you want to start from the instance called problem5.xml, and .xml as third argument.";
            String prefix = ArgumentsManager.getParameter("prefix", String.valueOf(s) + "\nName (prefix) of the instance series (without number and extension) : ");
            int number = ArgumentsManager.getIntParameter("number ", " Number of the first file instance : ", 0, 1000000);
            String suffix = ArgumentsManager.getParameter("suffix", "Extension (suffix) of the instance series : ");
            int index = prefix.lastIndexOf(File.separatorChar);
            String instancePath = index == -1 ? "" : prefix.substring(0, index + 1);
            String instanceFileNamePrefix = index == -1 ? prefix : prefix.substring(index + 1);
            int i = 0;
            while (i < ArgumentsManager.getNbInstances()) {
                instanceFilenames.add(String.valueOf(instancePath) + instanceFileNamePrefix + (number + i) + suffix);
                ++i;
            }
            return instanceFilenames;
        }
        File file = new File(first);
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        if (file.isFile()) {
            instanceFilenames.add(first);
            return instanceFilenames;
        }
        if (file.isDirectory()) {
            Problem0.operateDirectory(file);
            return instanceFilenames;
        }
        return null;
    }

    @Override
    protected void setParametersOfInstance(int numInstance) {
        this.parameters = new Parameters();
        if (instanceFilenames == null) {
            instanceFilenames = Problem0.loadInstanceFilenames();
            ArgumentsManager.setNbInstances(instanceFilenames.size());
        }
        ((Parameters)this.parameters).instanceFileName = instanceFilenames.get(numInstance);
    }

    @Override
    protected void addVariables() {
        ExtensionConstraint.clear();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            InstanceHandler instanceHandler = new InstanceHandler(this);
            saxParser.parse(((Parameters)this.parameters).instanceFileName, (DefaultHandler)instanceHandler);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    @Override
    protected void addConstraints() {
    }

    @Override
    protected void attachToCore() {
        this.addVariables();
    }

    class Parameters
    implements IParameters {
        String instanceFileName;

        Parameters() {
        }
    }
}

