/*
 * Decompiled with CFR 0.152.
 */
package XSax;

import XSax.Problem0;
import abscon.Resolution;
import abscon.constants.Expr;
import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.Constraint;
import abscon.constraints.ConstraintBuilder;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.ExtensionConstraintV;
import abscon.constraints.extension.RelationDefinition;
import abscon.constraints.extension.Semantics;
import abscon.constraints.extension.structures.Bits;
import abscon.constraints.global.AllDifferent;
import abscon.constraints.universal.UniversalConstraint;
import abscon.constraints.universal.evaluators.EvaluationManager;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.MaxCSP;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.SingletonMaxCSP3Single;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import abscon.tools.math.LexicographicComparator;
import abscon.xml.ExpressionBuilder;
import abscon.xml.OutputManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class InstanceHandler
extends DefaultHandler {
    private static final double LOAD_FACTOR_LIMIT = 0.7;
    private static final long RELATION_CONTRACTION_LIMIT = 100000000L;
    private Problem0 problem;
    private Map<String, int[]> mapOfDomains;
    private Map<String, Variable> mapOfVariables;
    private Map<String, int[][]> mapOfRelations;
    private Map<String, Semantics> mapOfRelationSemantics;
    private Map<String, String> mapOfPredicates;
    private int nbSingletonDomainVariables;
    private int nbGlobalConstraints;
    private int nbUniversalConstraints;
    private String currentDomainName;
    private String currentRelationName;
    private int arity;
    private int nbTuples;
    private String currentPredicateName;
    private String parameters;
    private String functional;
    private String currentConstraintName;
    Variable[] currentInvolvedVariables;
    private String reference;
    private StringBuffer currentBuffer = new StringBuffer();
    private UnaryManager unaryManager = new UnaryManager();
    private ExtentionalManager extensionalManager = new ExtentionalManager();
    private IntentionalManager intentionalManager = new IntentionalManager();
    private LexicographicComparator comparator = new LexicographicComparator();
    private boolean mergeConstraintsOfSimilarScope = true;
    private Map<HashKey, int[]> map;
    private HashKey hashKey;
    boolean preserveConstraints;

    private void contract(int[][] m) {
        int i = 0;
        while (i < m.length) {
            if (this.hashKey == null) {
                this.hashKey = new HashKey();
            }
            this.hashKey.t = m[i];
            int[] t = this.map.get(this.hashKey);
            if (t == null) {
                this.map.put(this.hashKey, m[i]);
                this.hashKey = null;
            } else {
                m[i] = t;
            }
            ++i;
        }
    }

    private void contractTupleRepresentation() {
        this.map = new HashMap<HashKey, int[]>(2000);
        for (int[][] m : this.mapOfRelations.values()) {
            this.contract(m);
        }
        System.gc();
    }

    public InstanceHandler(Problem0 problem) {
        this.problem = problem;
        String className = ConfigurationManager.getString(0, "preprocessing/propagationTechnique", "class");
        this.preserveConstraints = className.equals(Tools.getRelativeClassNameOf(MaxCSP.class)) || className.equals(Tools.getRelativeClassNameOf(SingletonMaxCSP3Single.class));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("constraint")) {
            this.currentConstraintName = attributes.getValue("name");
            this.currentInvolvedVariables = ConstraintBuilder.extractInvolvedVariablesFrom(attributes.getValue("scope"), this.mapOfVariables);
            this.reference = attributes.getValue("reference");
        } else if (qName.equals("variable")) {
            String name = attributes.getValue("name");
            String domainName = attributes.getValue("domain");
            int[] values = this.mapOfDomains.get(domainName);
            if (values.length == 1 || values.length == 3 && values[0] == values[1]) {
                ++this.nbSingletonDomainVariables;
            }
            Variable variable = ConstraintBuilder.buildVariable(this.problem, name, values);
            variable.getDomain().setDomainTypeName(domainName);
            this.mapOfVariables.put(name, variable);
            this.problem.addVariable(variable);
        } else if (qName.equals("relation")) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
            this.currentRelationName = attributes.getValue("name");
            this.arity = Integer.parseInt(attributes.getValue("arity"));
            this.nbTuples = Integer.parseInt(attributes.getValue("nbTuples"));
            this.mapOfRelationSemantics.put(this.currentRelationName, Semantics.searchFrom(attributes.getValue("semantics")));
        } else if (qName.equals("predicate")) {
            this.currentPredicateName = attributes.getValue("name");
        } else if (qName.equals("domain")) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
            this.currentDomainName = attributes.getValue("name");
        } else if (qName.equals("parameters")) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
        } else if (qName.equals("functional")) {
            this.currentBuffer.delete(0, this.currentBuffer.length());
        } else if (qName.equals("domains")) {
            OutputManager.print("domains being loaded...", true);
            int nbDomains = Integer.parseInt(attributes.getValue("nbDomains"));
            this.mapOfDomains = new HashMap<String, int[]>((int)Math.ceil((double)nbDomains / 0.7));
        } else if (qName.equals("variables")) {
            OutputManager.print("variables being loaded...", true);
            int nbVariables = Integer.parseInt(attributes.getValue("nbVariables"));
            this.mapOfVariables = new HashMap<String, Variable>((int)Math.ceil((double)nbVariables / 0.7));
        } else if (qName.equals("relations")) {
            OutputManager.print("relations being loaded...", true);
            int nbRelations = Integer.parseInt(attributes.getValue("nbRelations"));
            this.mapOfRelations = new HashMap<String, int[][]>((int)Math.ceil((double)nbRelations / 0.7));
            this.mapOfRelationSemantics = new HashMap<String, Semantics>((int)Math.ceil((double)nbRelations / 0.7));
        } else if (qName.equals("predicates")) {
            OutputManager.print("predicates being loaded...", true);
            int nbPredicates = Integer.parseInt(attributes.getValue("nbPredicates"));
            this.mapOfPredicates = new HashMap<String, String>((int)Math.ceil((double)nbPredicates / 0.7));
        } else if (qName.equals("constraints")) {
            OutputManager.print("constraints being loaded...", true);
            if (this.mapOfRelations == null) {
                this.mapOfRelations = new HashMap<String, int[][]>(0);
                this.mapOfRelationSemantics = new HashMap<String, Semantics>(0);
            }
            if (this.mapOfPredicates == null) {
                this.mapOfPredicates = new HashMap<String, String>(0);
            }
            this.mapOfDomains.clear();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentBuffer.append(ch, start, length);
    }

    private void purge() {
        boolean reductable = this.problem.getResolution().getNbSearchedSolutions() == 1;
        for (Variable variable : this.problem.getCollectedVariables()) {
            if (variable.getCollectedConstraints().size() == 0) {
                this.problem.incrementNbDisconnectedVariables();
                if (reductable) {
                    Domain domain = variable.getDomain();
                    Elements elements = domain.getElements();
                    int index = elements.getFirstPresent();
                    index = elements.getNextPresent(index);
                    while (index != -1) {
                        domain.removeDefinitivelyElementAt(index);
                        index = elements.getNextPresent(index);
                    }
                }
            }
            if (variable.getDomain().getCurrentSize() != 1) continue;
            this.problem.incrementNbSingletonDomainVariables();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("constraint")) {
            if (this.currentInvolvedVariables.length == 1) {
                if (this.mapOfRelations.containsKey(this.reference)) {
                    this.unaryManager.dealWith(this.currentInvolvedVariables[0], this.reference, null);
                    return;
                } else {
                    if (!this.mapOfPredicates.containsKey(this.reference)) throw new RuntimeException();
                    String[] effectiveParameters = ConstraintBuilder.extractEffectiveParameters(this.parameters);
                    String predicate = ConstraintBuilder.buildPredicateExpression(this.mapOfPredicates.get(this.reference), effectiveParameters);
                    this.unaryManager.dealWith(this.currentInvolvedVariables[0], this.reference, UniversalConstraint.getUniversalPredicateExpressionOf(predicate, this.currentInvolvedVariables));
                }
                return;
            }
            AllDifferent constraint = null;
            if (this.mapOfRelations.containsKey(this.reference)) {
                this.extensionalManager.dealWith(this.currentConstraintName, this.currentInvolvedVariables, this.reference);
                return;
            } else if (this.mapOfPredicates.containsKey(this.reference)) {
                Arrays.sort(this.currentInvolvedVariables);
                String[] effectiveParameters = ConstraintBuilder.extractEffectiveParameters(this.parameters);
                String predicate = ConstraintBuilder.buildPredicateExpression(this.mapOfPredicates.get(this.reference), effectiveParameters);
                this.intentionalManager.dealWith(this.currentConstraintName, this.currentInvolvedVariables, predicate);
                return;
            } else {
                ++this.nbGlobalConstraints;
                if (!this.reference.equals(XMLInstanceRepresentation.getGlobalNameOf("allDifferent"))) throw new RuntimeException();
                constraint = new AllDifferent(this.problem, this.currentInvolvedVariables);
                constraint.setName(this.currentConstraintName);
                this.problem.addConstraint(constraint);
            }
            return;
        } else if (qName.equals("relation")) {
            if (Tools.getUsedMemory() > 100000000L && this.map == null) {
                OutputManager.printInfo("Contraction of relations, mem = " + Tools.getFormattedUsedMemorySize());
                this.contractTupleRepresentation();
            }
            int[][] m = ConstraintBuilder.buildTuples(this.nbTuples, this.arity, this.currentBuffer.toString());
            if (this.map != null) {
                this.contract(m);
            }
            this.mapOfRelations.put(this.currentRelationName, m);
            return;
        } else if (qName.equals("predicate")) {
            String postfixPredicateExpression = ExpressionBuilder.buildPostfixExpression(this.functional, ConstraintBuilder.extractFormalParameters(this.parameters));
            this.mapOfPredicates.put(this.currentPredicateName, postfixPredicateExpression);
            return;
        } else if (qName.equals("domain")) {
            this.mapOfDomains.put(this.currentDomainName, ConstraintBuilder.buildDomainValues(this.currentBuffer.toString()));
            return;
        } else if (qName.equals("parameters")) {
            this.parameters = this.currentBuffer.toString();
            return;
        } else if (qName.equals("functional")) {
            this.functional = this.currentBuffer.toString();
            return;
        } else if (qName.equals("variables")) {
            this.problem.setNbDomainTypes(this.mapOfDomains.size());
            this.problem.storeVariablesToArray();
            return;
        } else {
            if (!qName.equals("constraints")) return;
            this.problem.setNbRelationTypes(this.mapOfRelations.size());
            this.problem.incrementNbGlobalConstraints(this.nbGlobalConstraints);
            this.extensionalManager.addConstraints();
            this.intentionalManager.addConstraints();
            this.unaryManager.addConstraints();
            this.purge();
            this.problem.storeConstraintsToArray();
            this.mapOfVariables.clear();
            this.mapOfRelations.clear();
            this.mapOfRelationSemantics.clear();
            this.mapOfPredicates.clear();
            this.unaryManager.clear();
            this.extensionalManager.clear();
            this.intentionalManager.clear();
            if (this.map != null) {
                this.map.clear();
            }
            Bits.clearMap();
            ExtensionConstraint.clear();
            UniversalConstraint.clear();
            Runtime.getRuntime().gc();
        }
    }

    class LocalUnaryConstraint {
        private Variable involvedVariable;
        private String reference;
        private String predicate;

        LocalUnaryConstraint(Variable involvedVariable, String reference, String predicate) {
            this.involvedVariable = involvedVariable;
            this.reference = reference;
            this.predicate = predicate;
        }
    }

    class UnaryManager {
        private List<LocalUnaryConstraint> listOfConstraints;

        UnaryManager() {
        }

        public void clear() {
            if (this.listOfConstraints != null) {
                this.listOfConstraints.clear();
            }
        }

        private void dealWith(Variable involvedVariable, String reference, String predicate) {
            LocalUnaryConstraint constraint = new LocalUnaryConstraint(involvedVariable, reference, predicate);
            if (this.listOfConstraints == null) {
                this.listOfConstraints = new ArrayList<LocalUnaryConstraint>();
            }
            this.listOfConstraints.add(constraint);
        }

        private boolean isPresent(int[][] t, int value) {
            int i = 0;
            while (i < t.length) {
                if (t[i][0] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void addConstraints() {
            if (this.listOfConstraints == null) {
                return;
            }
            if (InstanceHandler.this.preserveConstraints) {
                for (LocalUnaryConstraint unaryConstraint : this.listOfConstraints) {
                    Constraint constraint;
                    Variable variable = unaryConstraint.involvedVariable;
                    String reference = unaryConstraint.reference;
                    if (InstanceHandler.this.mapOfRelations.containsKey(reference)) {
                        constraint = ConstraintBuilder.buildConstraintInExtension(InstanceHandler.this.problem, new Variable[]{variable}, (int[][])InstanceHandler.this.mapOfRelations.get(reference), (Semantics)((Object)InstanceHandler.this.mapOfRelationSemantics.get(reference)), null);
                        InstanceHandler.this.problem.addConstraint(constraint);
                        continue;
                    }
                    if (InstanceHandler.this.mapOfPredicates.containsKey(reference)) {
                        constraint = new UniversalConstraint(InstanceHandler.this.problem, new Variable[]{variable}, unaryConstraint.predicate, null, false);
                        InstanceHandler.this.problem.addConstraint(constraint);
                        continue;
                    }
                    throw new IllegalArgumentException("global constraint with only one involved variable");
                }
                InstanceHandler.this.problem.incrementNbUnaryConstraints(this.listOfConstraints.size());
                return;
            }
            int nbRemovals = 0;
            for (LocalUnaryConstraint unaryConstraint : this.listOfConstraints) {
                int index;
                Variable variable = unaryConstraint.involvedVariable;
                String reference = unaryConstraint.reference;
                Domain domain = variable.getDomain();
                Elements elements = domain.getElements();
                if (InstanceHandler.this.mapOfRelations.containsKey(reference)) {
                    int[][] t = (int[][])InstanceHandler.this.mapOfRelations.get(reference);
                    Semantics semantics = (Semantics)((Object)InstanceHandler.this.mapOfRelationSemantics.get(reference));
                    index = elements.getFirstPresent();
                    while (index != -1) {
                        if (this.isPresent(t, domain.toValue(index)) != (semantics == Semantics.SUPPORTS)) {
                            ++nbRemovals;
                            domain.removeDefinitivelyElementAt(index);
                        }
                        index = elements.getNextPresent(index);
                    }
                    continue;
                }
                if (InstanceHandler.this.mapOfPredicates.containsKey(reference)) {
                    EvaluationManager evaluationManager = new EvaluationManager(unaryConstraint.predicate);
                    int[] t = new int[1];
                    index = elements.getFirstPresent();
                    while (index != -1) {
                        t[0] = domain.toValue(index);
                        if (!evaluationManager.check(t)) {
                            ++nbRemovals;
                            domain.removeDefinitivelyElementAt(index);
                        }
                        index = elements.getNextPresent(index);
                    }
                    continue;
                }
                throw new IllegalArgumentException("global constraint with only one involved variable");
            }
            InstanceHandler.this.problem.incrementNbUnaryConstraints(this.listOfConstraints.size());
        }
    }

    class LocalExtensionalConstraint {
        private String name;
        private Variable[] involvedVariables;
        private String key;
        private List<RelationDefinition> listOfRelations = new ArrayList<RelationDefinition>();
        private RelationDefinition mergedRelation;
        private int[] dst;

        LocalExtensionalConstraint(String name, Variable[] involvedVariables, String reference) {
            this.name = name;
            this.involvedVariables = involvedVariables;
            this.key = reference;
            int i = 0;
            while (i < involvedVariables.length) {
                this.key = String.valueOf(this.key) + involvedVariables[i].getDomain().getDomainTypeName();
                ++i;
            }
            int[] mapping = new int[involvedVariables.length];
            int i2 = 0;
            while (i2 < mapping.length) {
                mapping[i2] = i2;
                ++i2;
            }
            this.listOfRelations.add(new RelationDefinition((int[][])InstanceHandler.this.mapOfRelations.get(reference), (Semantics)((Object)InstanceHandler.this.mapOfRelationSemantics.get(reference)), mapping));
            this.dst = new int[involvedVariables.length];
        }

        private int getPosition(Variable[] variables, Variable variable) {
            int i = 0;
            while (i < variables.length) {
                if (variables[i] == variable) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int[] getMapping(Variable[] srcVariables, Variable[] dstVariables) {
            int[] mapping = new int[srcVariables.length];
            int i = 0;
            while (i < srcVariables.length) {
                mapping[i] = this.getPosition(dstVariables, srcVariables[i]);
                ++i;
            }
            return mapping;
        }

        private int[] mapTuple(int[] src, int[] dst, int[] mapping) {
            int i = 0;
            while (i < dst.length) {
                dst[i] = src[mapping[i]];
                ++i;
            }
            return dst;
        }

        void add(String otherName, Variable[] otherVariables, String otherReference) {
            this.name = String.valueOf(this.name) + "+" + otherName;
            int[] mapping = this.getMapping(this.involvedVariables, otherVariables);
            this.key = String.valueOf(this.key) + otherReference;
            int i = 0;
            while (i < mapping.length) {
                this.key = String.valueOf(this.key) + mapping[i];
                ++i;
            }
            this.listOfRelations.add(new RelationDefinition((int[][])InstanceHandler.this.mapOfRelations.get(otherReference), (Semantics)((Object)InstanceHandler.this.mapOfRelationSemantics.get(otherReference)), mapping));
        }

        int getSmallestSupportsIn(RelationDefinition[] rels) {
            int index = -1;
            int smallest = Integer.MAX_VALUE;
            int i = 0;
            while (i < rels.length) {
                if (rels[i].semantics == Semantics.SUPPORTS && rels[i].tuples.length < smallest) {
                    index = i;
                    smallest = rels[i].tuples.length;
                }
                ++i;
            }
            return index;
        }

        void merge() {
            if (this.listOfRelations.size() == 1) {
                this.mergedRelation = this.listOfRelations.get(0);
            } else {
                TreeSet<int[]> set = new TreeSet<int[]>(InstanceHandler.this.comparator);
                RelationDefinition[] rels = this.listOfRelations.toArray(new RelationDefinition[this.listOfRelations.size()]);
                int index = this.getSmallestSupportsIn(rels);
                if (index == -1) {
                    int[][] tuples = rels[0].tuples;
                    int i = 0;
                    while (i < tuples.length) {
                        set.add(tuples[i]);
                        ++i;
                    }
                    int cnt = 1;
                    while (cnt < rels.length) {
                        tuples = rels[cnt].tuples;
                        int[] mapping = rels[cnt].mapping;
                        int i2 = 0;
                        while (i2 < tuples.length) {
                            set.add((int[])this.mapTuple(tuples[i2], this.dst, mapping).clone());
                            ++i2;
                        }
                        ++cnt;
                    }
                    this.mergedRelation = new RelationDefinition((int[][])set.toArray((T[])new int[set.size()][]), Semantics.CONFLICTS, null);
                } else {
                    int[][] tuples = rels[index].tuples;
                    int[] mapping = rels[index].mapping;
                    int[] tuple = new int[this.involvedVariables.length];
                    int i = 0;
                    while (i < tuples.length) {
                        this.mapTuple(tuples[i], tuple, mapping);
                        boolean allowed = true;
                        int cnt = 0;
                        while (allowed && cnt < rels.length) {
                            if (cnt != index) {
                                if (cnt == 0) {
                                    if (Arrays.binarySearch(rels[0].tuples, tuple, InstanceHandler.this.comparator) >= 0 != (rels[0].semantics == Semantics.SUPPORTS)) {
                                        allowed = false;
                                    }
                                } else if (Arrays.binarySearch(rels[cnt].tuples, this.mapTuple(tuple, this.dst, rels[cnt].reverseMapping), InstanceHandler.this.comparator) >= 0 != (rels[cnt].semantics == Semantics.SUPPORTS)) {
                                    allowed = false;
                                }
                            }
                            ++cnt;
                        }
                        if (allowed) {
                            set.add((int[])tuple.clone());
                        }
                        ++i;
                    }
                    this.mergedRelation = new RelationDefinition((int[][])set.toArray((T[])new int[set.size()][]), Semantics.SUPPORTS, null);
                }
            }
        }
    }

    class HashKey {
        private int[] t;

        HashKey() {
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((HashKey)object).t);
        }
    }

    class ExtentionalManager {
        private List<LocalExtensionalConstraint> listOfConstraints;
        private Map<String, LocalExtensionalConstraint> mapOfScopes;
        private Map<String, List<LocalExtensionalConstraint>> mapOfKeys;

        ExtentionalManager() {
        }

        public void clear() {
            if (this.listOfConstraints != null) {
                this.listOfConstraints.clear();
                this.mapOfScopes.clear();
                this.mapOfKeys.clear();
            }
        }

        private String buildScopeFrom(Variable[] involvedVariables) {
            StringBuffer sb = new StringBuffer(involvedVariables.length * 3);
            int i = 0;
            while (i < involvedVariables.length) {
                sb.append(involvedVariables[i].getName());
                ++i;
            }
            return sb.toString();
        }

        private void dealWith(String name, Variable[] involvedVariables, String reference) {
            List<LocalExtensionalConstraint> list;
            if (this.listOfConstraints == null) {
                this.listOfConstraints = new ArrayList<LocalExtensionalConstraint>();
                this.mapOfScopes = new HashMap<String, LocalExtensionalConstraint>();
                this.mapOfKeys = new HashMap<String, List<LocalExtensionalConstraint>>();
            }
            if (((int[][])InstanceHandler.this.mapOfRelations.get(reference)).length == 0 && InstanceHandler.this.mapOfRelationSemantics.get(reference) == Semantics.CONFLICTS) {
                InstanceHandler instanceHandler = InstanceHandler.this;
                instanceHandler.nbUniversalConstraints = instanceHandler.nbUniversalConstraints + 1;
                return;
            }
            LocalExtensionalConstraint constraint = null;
            String scope = null;
            if (InstanceHandler.this.mergeConstraintsOfSimilarScope && !InstanceHandler.this.preserveConstraints && InstanceHandler.this.mapOfRelationSemantics.get(reference) != Semantics.SOFT) {
                Object[] copy = (Variable[])involvedVariables.clone();
                Arrays.sort(copy);
                scope = this.buildScopeFrom((Variable[])copy);
                constraint = this.mapOfScopes.get(scope);
            }
            if (constraint == null) {
                constraint = new LocalExtensionalConstraint(name, involvedVariables, reference);
                this.listOfConstraints.add(constraint);
                if (scope != null) {
                    this.mapOfScopes.put(scope, constraint);
                }
                if ((list = this.mapOfKeys.get(constraint.key)) == null) {
                    list = new LinkedList<LocalExtensionalConstraint>();
                }
                list.add(constraint);
                this.mapOfKeys.put(constraint.key, list);
            } else {
                InstanceHandler.this.problem.incrementNbMergedConstraint();
                list = this.mapOfKeys.get(constraint.key);
                list.remove(constraint);
                if (list.size() == 0) {
                    this.mapOfKeys.remove(constraint.key);
                }
                constraint.add(name, involvedVariables, reference);
                list = this.mapOfKeys.get(constraint.key);
                if (list == null) {
                    list = new LinkedList<LocalExtensionalConstraint>();
                }
                list.add(constraint);
                this.mapOfKeys.put(constraint.key, list);
            }
        }

        private void addConstraints() {
            if (this.listOfConstraints == null) {
                return;
            }
            Set<String> set = this.mapOfKeys.keySet();
            for (String key : set) {
                Iterator<LocalExtensionalConstraint> iterator = this.mapOfKeys.get(key).iterator();
                LocalExtensionalConstraint first = iterator.next();
                first.merge();
                ExtensionConstraint constraint = ConstraintBuilder.buildConstraintInExtension(InstanceHandler.this.problem, first.involvedVariables, ((LocalExtensionalConstraint)first).mergedRelation.tuples, ((LocalExtensionalConstraint)first).mergedRelation.semantics, first.key);
                constraint.setRelationTypeName(first.key);
                constraint.setName(first.name);
                InstanceHandler.this.problem.addConstraint(constraint);
                while (iterator.hasNext()) {
                    LocalExtensionalConstraint other = iterator.next();
                    ExtensionConstraint otherConstraint = ConstraintBuilder.buildConstraintInExtension(InstanceHandler.this.problem, other.involvedVariables, ((LocalExtensionalConstraint)first).mergedRelation.tuples, ((LocalExtensionalConstraint)first).mergedRelation.semantics, first.key);
                    otherConstraint.setRelationTypeName(first.key);
                    otherConstraint.setName(other.name);
                    InstanceHandler.this.problem.addConstraint(otherConstraint);
                }
                first.mergedRelation = null;
            }
        }
    }

    class LocalIntentionalConstraint {
        private Variable[] involvedVariables;
        private List<String> list = new LinkedList<String>();
        private String universalPredicateExpression;

        String getUniversalPredicateExpression() {
            return this.universalPredicateExpression;
        }

        private long getDomainSize() {
            if (this.involvedVariables.length != 2) {
                return -1L;
            }
            return this.involvedVariables[0].getDomain().getMaximumSize() * this.involvedVariables[1].getDomain().getMaximumSize();
        }

        LocalIntentionalConstraint(String name, Variable[] involvedVariables, String predicate) {
            if (involvedVariables.length == 2 && involvedVariables[0].getDomain().getDomainTypeName().compareTo(involvedVariables[1].getDomain().getDomainTypeName()) > 0) {
                Variable tmp = involvedVariables[0];
                involvedVariables[0] = involvedVariables[1];
                involvedVariables[1] = tmp;
            }
            this.involvedVariables = involvedVariables;
            this.list.add(Expr.formatPredicate(predicate));
        }

        void mergeWith(String otherName, String otherPredicate) {
            this.list.add(otherPredicate);
        }

        private String potentiallySwapVariablesOf(String universalPredicateExpression) {
            boolean found = false;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(universalPredicateExpression);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("X")) {
                    int id = Integer.parseInt(token.substring("X".length()));
                    if (!found && id == 0) {
                        return universalPredicateExpression;
                    }
                    found = true;
                    sb.append(XMLInstanceRepresentation.getParameterNameFor(id == 0 ? 1 : 0));
                } else {
                    sb.append(token);
                }
                if (!st.hasMoreTokens()) continue;
                sb.append(' ');
            }
            Variable tmp = this.involvedVariables[0];
            this.involvedVariables[0] = this.involvedVariables[1];
            this.involvedVariables[1] = tmp;
            return sb.toString();
        }

        void computeUniversalPredicateExpression() {
            Object[] predicates = this.list.toArray(new String[this.list.size()]);
            int i = 0;
            while (i < predicates.length) {
                predicates[i] = UniversalConstraint.getUniversalPredicateExpressionOf(predicates[i], this.involvedVariables);
                ++i;
            }
            if (this.involvedVariables.length == 2) {
                Arrays.sort(predicates);
            }
            Object predicate = predicates[0];
            int i2 = 1;
            while (i2 < predicates.length) {
                predicate = Expr.formatPredicate(Expr.and(predicate, predicates[i2]));
                ++i2;
            }
            this.universalPredicateExpression = this.involvedVariables.length == 2 && this.involvedVariables[0].getDomain().getDomainTypeName().equals(this.involvedVariables[1].getDomain().getDomainTypeName()) ? this.potentiallySwapVariablesOf((String)predicate) : predicate;
        }

        String getKey() {
            if (this.universalPredicateExpression == null) {
                throw new RuntimeException();
            }
            StringBuffer sb = new StringBuffer();
            Variable[] variableArray = this.involvedVariables;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                sb.append(variable.getDomain().getDomainTypeName());
                ++n;
            }
            sb.append(this.universalPredicateExpression);
            String key = sb.toString();
            return key;
        }
    }

    class IntentionalManager {
        private List<LocalIntentionalConstraint> listOfConstraints;
        private Map<String, LocalIntentionalConstraint> mapOfScopes;
        private boolean convertBinary = ConfigurationManager.getBoolean(0, "problem/convertBinaryConstraintsInExtension", "value");
        private int limitConvertBinary;

        public void clear() {
            if (this.listOfConstraints != null) {
                this.listOfConstraints.clear();
                this.mapOfScopes.clear();
            }
        }

        IntentionalManager() {
            if (this.convertBinary) {
                this.limitConvertBinary = ConfigurationManager.getInt(0, "problem/convertBinaryConstraintsInExtension", "limit");
                this.limitConvertBinary = this.limitConvertBinary == -1 ? Integer.MAX_VALUE : this.limitConvertBinary * 1000;
            }
        }

        private String buildScopeFrom(Variable[] involvedVariables) {
            StringBuffer sb = new StringBuffer(involvedVariables.length * 3);
            int i = 0;
            while (i < involvedVariables.length) {
                sb.append(involvedVariables[i].getName());
                ++i;
            }
            return sb.toString();
        }

        private void dealWith(String name, Variable[] involvedVariables, String predicate) {
            if (this.listOfConstraints == null) {
                this.listOfConstraints = new ArrayList<LocalIntentionalConstraint>();
                this.mapOfScopes = new HashMap<String, LocalIntentionalConstraint>();
            }
            LocalIntentionalConstraint constraint = null;
            String scope = null;
            if (InstanceHandler.this.mergeConstraintsOfSimilarScope && !InstanceHandler.this.preserveConstraints) {
                Object[] copy = (Variable[])involvedVariables.clone();
                Arrays.sort(copy);
                scope = this.buildScopeFrom((Variable[])copy);
                constraint = this.mapOfScopes.get(scope);
            }
            if (constraint == null) {
                constraint = new LocalIntentionalConstraint(name, involvedVariables, predicate);
                this.listOfConstraints.add(constraint);
                if (scope != null) {
                    this.mapOfScopes.put(scope, constraint);
                }
            } else {
                InstanceHandler.this.problem.incrementNbMergedConstraint();
                constraint.mergeWith(name, predicate);
            }
        }

        private Constraint convert(LocalIntentionalConstraint intentionalConstraint) {
            ExtensionConstraintV constraint = new ExtensionConstraintV(InstanceHandler.this.problem, intentionalConstraint.involvedVariables);
            constraint.setSupports(intentionalConstraint.getUniversalPredicateExpression(), intentionalConstraint.getKey());
            InstanceHandler.this.problem.incrementNbConvertedConstraints();
            return constraint;
        }

        private void addConstraints() {
            if (this.listOfConstraints == null) {
                return;
            }
            boolean mustBuildConflictsSTructure = UniversalConstraint.mustBuildConflictsStructure();
            for (LocalIntentionalConstraint intentionalConstraint : this.listOfConstraints) {
                intentionalConstraint.computeUniversalPredicateExpression();
                if (this.convertBinary && (Resolution.getResolutionStopwatch().getCurrentCpuTime() > (long)this.limitConvertBinary || Tools.getUsedMemory() > 400000000L)) {
                    OutputManager.printInfo("Stopping converting binary constraints (cpu=" + (double)Resolution.getResolutionStopwatch().getCurrentCpuTime() / 1000.0 + ", mem = " + Tools.getFormattedUsedMemorySize() + ")");
                    this.convertBinary = false;
                    mustBuildConflictsSTructure = false;
                }
                Constraint constraint = null;
                constraint = this.convertBinary && intentionalConstraint.involvedVariables.length == 2 && intentionalConstraint.getDomainSize() < 10000000L ? this.convert(intentionalConstraint) : new UniversalConstraint(InstanceHandler.this.problem, intentionalConstraint.involvedVariables, intentionalConstraint.getUniversalPredicateExpression(), intentionalConstraint.getKey(), mustBuildConflictsSTructure && (intentionalConstraint.involvedVariables.length > 2 || intentionalConstraint.getDomainSize() < 10000000L));
                InstanceHandler.this.problem.addConstraint(constraint);
            }
        }
    }
}

