/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.xml.ErrorHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLManipulation {
    private static void dealWithException(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException ee = (SAXParseException)e;
            System.out.println("\n** Parsing error, line " + ee.getLineNumber() + ", uri " + ee.getSystemId());
            System.out.println("   " + ee.getMessage());
            Exception x = ee.getException() == null ? ee : ee.getException();
            x.printStackTrace();
        } else if (e instanceof SAXException) {
            SAXException ee = (SAXException)e;
            Exception x = ee.getException() == null ? ee : ee.getException();
            x.printStackTrace();
        } else if (e instanceof TransformerConfigurationException) {
            TransformerConfigurationException ee = (TransformerConfigurationException)e;
            System.out.println("\n** Transformer Factory error\n" + e.getMessage());
            Throwable x = ee.getException() == null ? ee : ee.getException();
            x.printStackTrace();
        } else if (e instanceof TransformerException) {
            TransformerException ee = (TransformerException)e;
            System.out.println("\n** Transformation error" + e.getMessage());
            Throwable x = ee.getException() == null ? ee : ee.getException();
            x.printStackTrace();
        } else {
            System.out.println(e);
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static Document createNewDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            XMLManipulation.dealWithException(e);
            return null;
        }
    }

    public static Document load(InputStream is, URL schemaUrl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (schemaUrl != null) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaUrl);
                documentBuilderFactory.setSchema(schema);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler());
            Document document = documentBuilder.parse(is);
            return document;
        }
        catch (Exception e) {
            XMLManipulation.dealWithException(e);
            return null;
        }
    }

    public static Document load(File file, URL schemaUrl) {
        try {
            return XMLManipulation.load(new FileInputStream(file), schemaUrl);
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + file.getName() + " does not exist");
            System.exit(1);
            return null;
        }
    }

    public static Document load(InputStream is) {
        return XMLManipulation.load(is, null);
    }

    public static Document load(File file) {
        return XMLManipulation.load(file, null);
    }

    public static Document load(String fileName) {
        return XMLManipulation.load(new File(fileName), null);
    }

    public static Document loadConfiguration(File file) {
        return XMLManipulation.load(file);
    }

    public static Document loadConfiguration(InputStream is) {
        return XMLManipulation.load(is);
    }

    private static Transformer buildTransformer(InputStream styleSheetInputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (styleSheetInputStream == null) {
                return transformerFactory.newTransformer();
            }
            Document document = XMLManipulation.load(styleSheetInputStream, null);
            DOMSource source = new DOMSource(document);
            return transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            XMLManipulation.dealWithException(e);
            return null;
        }
    }

    public static void save(Document document, PrintWriter writer, InputStream styleSheetInputStream) {
        try {
            Transformer transformer = XMLManipulation.buildTransformer(styleSheetInputStream);
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            XMLManipulation.dealWithException(e);
        }
    }

    public static void save(Document document, String fileName, InputStream styleSheetInputStream) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            XMLManipulation.save(document, out, styleSheetInputStream);
            out.close();
        }
        catch (IOException e) {
            XMLManipulation.dealWithException(e);
        }
    }

    public static void save(Document document, String fileName) {
        XMLManipulation.save(document, fileName, null);
    }

    public static void saveInstance(Document document, String fileName) {
        boolean format2 = true;
        String styleSheetFileName = format2 ? "instance_2_0.xsl" : "instance_1_1.xsl";
        XMLManipulation.save(document, fileName);
    }

    public static Element getElementByTagNameFrom(Element element, String tagName, int i) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList.getLength() <= i) {
            return null;
        }
        return (Element)nodeList.item(i);
    }

    public static Element getFirstElementByTagNameFromRoot(Document document, String tagName) {
        return XMLManipulation.getElementByTagNameFrom(document.getDocumentElement(), tagName, 0);
    }

    public static void deleteElementByTagNameFrom(Element element, String tagName, int i) {
        NodeList list = element.getElementsByTagName(tagName);
        if (list.getLength() <= i) {
            throw new IllegalArgumentException();
        }
        element.removeChild(list.item(i));
    }

    public static Node getChildElement(Document document, String elementName, int index) {
        NodeList list = document.getElementsByTagName(elementName);
        return list.item(index);
    }

    public static void deleteChildElement(Document document, String elementName, int index) {
        Element element = (Element)document.getElementsByTagName(elementName).item(0);
        element.removeChild(XMLManipulation.getChildElement(document, elementName, index));
    }
}

