/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.ExtractionResolution;
import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.xml.ProblemDocumentBuilder;
import abscon.xml.State;
import abscon.xml.XMLManipulation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProblemDocumentBuilder1_1
extends ProblemDocumentBuilder {
    protected List<Relation> relations = new LinkedList<Relation>();
    protected List<Predicate> predicates = new LinkedList<Predicate>();

    private Element buildDomainElement(String values, int id) {
        Element domainElement = this.document.createElement("domain");
        domainElement.setAttribute("name", XMLInstanceRepresentation.getDomainNameFor(id));
        domainElement.setAttribute("nbValues", String.valueOf(this.getNbValuesOf(values)));
        domainElement.setAttribute("values", values);
        return domainElement;
    }

    private Element buildDomainsElement(String[] domainsValues) {
        Element domainsElement = this.document.createElement("domains");
        domainsElement.setAttribute("nbDomains", String.valueOf(domainsValues.length));
        int i = 0;
        while (i < domainsValues.length) {
            domainsElement.appendChild(this.buildDomainElement(domainsValues[i], i));
            ++i;
        }
        return domainsElement;
    }

    private String[] getDomainsValues(Variable[] variables) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            String s = variables[i].getDomain().getStringListOfValues();
            int index = list.indexOf(s);
            if (index == -1) {
                list.add(s);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private int getDomainIdOf(String[] list, String s) {
        int i = 0;
        while (i < list.length) {
            if (list[i].compareTo(s) == 0) {
                return i;
            }
            ++i;
        }
        assert (false);
        return -1;
    }

    private Element buildVariableElement(Variable variable, String[] domainDefinitions) {
        Element variableElement = this.document.createElement("variable");
        variableElement.setAttribute("name", variable.getName(this.canonicalForm));
        String domainName = XMLInstanceRepresentation.getDomainNameFor(this.getDomainIdOf(domainDefinitions, variable.getDomain().getStringListOfValues()));
        variableElement.setAttribute("domain", domainName);
        this.domainNamesOfVariables[variable.getId()] = domainName;
        return variableElement;
    }

    private Element buildVariablesElement(Variable[] variables, String[] domainDefinitions) {
        Element variablesElement = this.document.createElement("variables");
        variablesElement.setAttribute("nbVariables", String.valueOf(this.state.getNbPresentVariables()));
        this.domainNamesOfVariables = new String[this.state.getProblem().getNbVariables()];
        int i = 0;
        while (i < variables.length) {
            if (this.state.isPresentVariable(i)) {
                variablesElement.appendChild(this.buildVariableElement(variables[i], domainDefinitions));
            }
            ++i;
        }
        return variablesElement;
    }

    private Element buildRelationElement(Relation relation) {
        Element relationElement = this.document.createElement("relation");
        relationElement.setAttribute("name", relation.name);
        relationElement.setAttribute("domain", relation.domain);
        if (relation.tuplesAreSupports) {
            relationElement.setAttribute("nbSupports", String.valueOf(relation.nbTuples));
            relationElement.setAttribute("supports", relation.tuples);
        } else {
            relationElement.setAttribute("nbConflicts", String.valueOf(relation.nbTuples));
            relationElement.setAttribute("conflicts", relation.tuples);
        }
        return relationElement;
    }

    private Element buildRelationsElement() {
        if (this.relations.isEmpty()) {
            return null;
        }
        Element relationsElement = this.document.createElement("relations");
        relationsElement.setAttribute("nbRelations", String.valueOf(this.relations.size()));
        for (Relation relation : this.relations) {
            relationsElement.appendChild(this.buildRelationElement(relation));
        }
        return relationsElement;
    }

    private Element buildPredicateElement(Predicate predicate) {
        Element predicateElement = this.document.createElement("predicate");
        predicateElement.setAttribute("name", predicate.name);
        predicateElement.setAttribute("expression", predicate.expression);
        return predicateElement;
    }

    private Element buildPredicatesElement() {
        if (this.predicates.isEmpty()) {
            return null;
        }
        Element predicatesElement = this.document.createElement("predicates");
        predicatesElement.setAttribute("nbPredicates", String.valueOf(this.predicates.size()));
        for (Predicate predicate : this.predicates) {
            predicatesElement.appendChild(this.buildPredicateElement(predicate));
        }
        return predicatesElement;
    }

    private String seekRelation(String domain, String tuplesAndSize) {
        int position = tuplesAndSize.lastIndexOf(35);
        assert (position != -1);
        String tuples = tuplesAndSize.substring(0, position);
        boolean supportOriented = tuplesAndSize.charAt(position + 1) == 'S';
        int nbTuples = Integer.parseInt(tuplesAndSize.substring(position + 2));
        for (Relation relation : this.relations) {
            if (!relation.hasSameDomainAndSameTuples(domain, supportOriented, nbTuples, tuples)) continue;
            return relation.name;
        }
        String relationName = XMLInstanceRepresentation.getRelationNameFor(this.relations.size());
        this.relations.add(new Relation(relationName, domain, supportOriented, nbTuples, tuples));
        return relationName;
    }

    private String seekPredicate(String domain, String expression) {
        for (Predicate predicate : this.predicates) {
            if (!predicate.hasSameExpression(expression)) continue;
            return predicate.name;
        }
        String predicateName = XMLInstanceRepresentation.getPredicateNameFor(this.predicates.size());
        this.predicates.add(new Predicate(predicateName, domain, expression));
        return predicateName;
    }

    private String setConstraintDomain(Constraint constraint) {
        String domain = "";
        Variable[] variableArray = constraint.getInvolvedVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            domain = String.valueOf(domain) + " " + this.domainNamesOfVariables[variable.getId()];
            ++n;
        }
        return domain.substring(1);
    }

    private Element buildConstraintElement(Constraint constraint) {
        Element constraintElement = this.document.createElement("constraint");
        constraintElement.setAttribute("name", constraint.getName());
        constraintElement.setAttribute("scope", constraint.getStringListOfVariables(this.canonicalForm));
        String domain = this.setConstraintDomain(constraint);
        if (!this.predicateForm || !constraint.canBeDefinedByAPredicate()) {
            constraintElement.setAttribute("relation", this.seekRelation(domain, constraint.getTupleManager().getStringListOfTuples()));
        } else {
            constraintElement.setAttribute("predicate", this.seekPredicate(domain, constraint.getPredicateExpression(2)));
        }
        return constraintElement;
    }

    private Element buildConstraintsElement(Constraint[] constraints) {
        this.relations.clear();
        Element constraintsElement = this.document.createElement("constraints");
        constraintsElement.setAttribute("nbConstraints", String.valueOf(this.state.getNbPresentConstraints()));
        int i = 0;
        while (i < constraints.length) {
            if (this.state.isPresentConstraint(i)) {
                constraintsElement.appendChild(this.buildConstraintElement(constraints[i]));
            }
            ++i;
        }
        return constraintsElement;
    }

    private String solutionToString(int[] t) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < t.length) {
            sb.append(String.valueOf(t[i]) + (i < t.length - 1 ? " " : ""));
            ++i;
        }
        return sb.toString();
    }

    private Element buildPresentationElement() {
        Problem problem = this.state.getProblem();
        boolean core = problem.getResolution() instanceof ExtractionResolution;
        boolean limited = problem.getResolution() == null || problem.getSolver() == null;
        Element presentationElement = this.document.createElement("presentation");
        presentationElement.setAttribute("name", this.canonicalForm ? "?" : problem.getName());
        if (!(limited || this.canonicalForm || core || problem.getSolver().getStatistics().getNbFoundSolutions() <= 0L)) {
            presentationElement.setAttribute("solution", problem.getSolver().getLastSolution().toString());
        }
        presentationElement.setAttribute("description", this.canonicalForm ? "?" : String.valueOf(core ? "core of " : "") + problem.getDescription());
        presentationElement.setAttribute("nbSolutions", limited || core || this.canonicalForm ? "?" : problem.getSolver().getStatusOfNbSolutions());
        presentationElement.setAttribute("format", "1.1");
        return presentationElement;
    }

    public ProblemDocumentBuilder1_1(State state, boolean predicateForm, boolean canonicalForm) {
        super(state, predicateForm, canonicalForm);
    }

    protected Document buildDocument() {
        this.document = XMLManipulation.createNewDocument();
        Element root = this.document.createElement("instance");
        root.appendChild(this.buildPresentationElement());
        String[] domainsValues = this.getDomainsValues(this.state.getProblem().getVariables());
        root.appendChild(this.buildDomainsElement(domainsValues));
        root.appendChild(this.buildVariablesElement(this.state.getProblem().getVariables(), domainsValues));
        Element constraintsElement = this.buildConstraintsElement(this.state.getProblem().getConstraints());
        Element predicatesElement = this.buildPredicatesElement();
        Element relationsElement = this.buildRelationsElement();
        if (relationsElement != null) {
            root.appendChild(relationsElement);
        }
        if (predicatesElement != null) {
            root.appendChild(predicatesElement);
        }
        root.appendChild(constraintsElement);
        this.document.appendChild(root);
        this.document.normalize();
        return this.document;
    }

    private static class Relation {
        String name;
        String domain;
        boolean tuplesAreSupports;
        int nbTuples;
        String tuples;

        Relation(String name, String domain, boolean tuplesAreSupports, int nbTuples, String tuples) {
            this.name = name;
            this.domain = domain;
            this.tuplesAreSupports = tuplesAreSupports;
            this.nbTuples = nbTuples;
            this.tuples = tuples;
        }

        boolean hasSameDomainAndSameTuples(String domain, boolean tuplesAreSupports, int nbTuples, String tuples) {
            return this.domain.equals(domain) && this.tuplesAreSupports == tuplesAreSupports && this.nbTuples == nbTuples && this.tuples.equals(tuples);
        }
    }

    private static class Predicate {
        String name;
        String domain;
        String expression;

        Predicate(String name, String domain, String expression) {
            this.name = name;
            this.domain = domain;
            this.expression = expression;
        }

        boolean hasSameDomainAndSameExpression(String domain, String expression) {
            return this.domain.equals(domain) && this.expression.equals(expression);
        }

        boolean hasSameExpression(String expression) {
            return this.expression.equals(expression);
        }
    }
}

