/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.Resolution;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ArgumentsManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.xml.XMLManipulation;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputManager {
    public static final int ID_ROOT = 0;
    public static final int ID_RESOLUTION = 1;
    public static final int ID_SOLVER = 2;
    public static final int INCREMENT_UNIT = 2;
    private static final String EMPTY_STRING = "                                                                                         ";
    public static String COMMENT_PREFIX = "   ";
    public static String INFO = "INFO : ";
    public static String DATA_SEPARATOR = "  ";
    private Document document;
    private Element root;
    private Element currentResolution;
    private Element currentSolver;
    private String outputFileName;
    private boolean active;
    private int mode = 3;
    Map<String, String> map = new LinkedHashMap<String, String>();

    public static void print(String s, boolean lineBefore) {
        if (lineBefore) {
            System.out.println(COMMENT_PREFIX);
        }
        System.out.println(String.valueOf(COMMENT_PREFIX) + s);
    }

    public static void printInfo(String s) {
        System.out.println(COMMENT_PREFIX);
        System.out.println(String.valueOf(COMMENT_PREFIX) + INFO + s);
    }

    public OutputManager(boolean active) {
        this.active = active;
        System.out.println(COMMENT_PREFIX);
        System.out.println("Abscon 109 (November, 2006)");
        System.out.println(COMMENT_PREFIX);
        System.out.println(String.valueOf(COMMENT_PREFIX) + "configuration");
        System.out.println(String.valueOf(COMMENT_PREFIX) + DATA_SEPARATOR + "name=" + ArgumentsManager.getConfigurationFileName());
        if (!active) {
            return;
        }
        this.document = XMLManipulation.createNewDocument();
        this.root = this.document.createElement("resolutions");
        this.root.setAttribute("configurationFileName", ArgumentsManager.getConfigurationFileName());
        this.document.appendChild(this.root);
        this.document.normalize();
    }

    private Element selectElementFrom(int id_element) {
        if (id_element == 0) {
            return this.root;
        }
        if (id_element == 1) {
            return this.currentResolution;
        }
        return this.currentSolver;
    }

    private String indentationFor(Element element) {
        int cpt = -1;
        Node parent = element.getParentNode();
        while (parent != null) {
            ++cpt;
            parent = parent.getParentNode();
        }
        return EMPTY_STRING.substring(0, cpt * 2);
    }

    public static String getFileNamePrefix(String fullInstanceName, String fullMethodName) {
        return String.valueOf(Tools.getRawInstanceName(fullInstanceName)) + "_" + Tools.getXMLBaseNameOf(fullMethodName) + "_";
    }

    private String getOutputFileNameFrom(String fullInstanceName) {
        String hostName = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            hostName = "unknown";
        }
        return String.valueOf(OutputManager.getFileNamePrefix(fullInstanceName, ArgumentsManager.getConfigurationFileName())) + hostName + "_" + Tools.getFormattedCurrentDate() + ".xml";
    }

    public void outputMap(String elementName, Map<String, String> map, int id_element) {
        if (this.mode == 0) {
            return;
        }
        if (this.mode == 2 || this.mode == 3) {
            Element parent = this.selectElementFrom(id_element);
            Element element = this.document.createElement(elementName);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    element.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            parent.appendChild(element);
            if (elementName.equals("resolution")) {
                this.currentResolution = element;
            }
            if (elementName.equals("solver")) {
                this.currentSolver = element;
            }
            if (elementName.equals("instance") && this.outputFileName == null) {
                this.outputFileName = this.getOutputFileNameFrom(map.get("name"));
            }
        }
        if (this.mode == 1 || this.mode == 3) {
            if (elementName.equals("resolution")) {
                return;
            }
            int limit = 120;
            if (elementName.equals("instance") && ArgumentsManager.getNbInstances() > 1) {
                System.out.println(COMMENT_PREFIX);
            }
            if (!(elementName.equals("variables") || elementName.equals("constraints") || elementName.equals("solver"))) {
                System.out.println(COMMENT_PREFIX);
                System.out.println(String.valueOf(COMMENT_PREFIX) + elementName);
            }
            if (map != null) {
                StringBuffer sb = new StringBuffer(COMMENT_PREFIX);
                Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
                while (it.hasNext()) {
                    String s;
                    Map.Entry<String, String> entry;
                    entry = it.next();
                    if (entry.getKey().equals("wckTime")) {
                        if (sb.length() > COMMENT_PREFIX.length()) {
                            System.out.println(sb.toString());
                        }
                        sb.delete(COMMENT_PREFIX.length(), sb.length());
                        s = String.valueOf(DATA_SEPARATOR) + entry.getKey() + "=" + entry.getValue();
                        sb.append("    =>");
                        sb.append(s);
                        entry = it.next();
                        s = String.valueOf(DATA_SEPARATOR) + entry.getKey() + "=" + entry.getValue();
                        sb.append(s);
                        entry = it.next();
                        s = String.valueOf(DATA_SEPARATOR) + entry.getKey() + "=" + entry.getValue();
                        sb.append(s);
                        break;
                    }
                    s = String.valueOf(DATA_SEPARATOR) + entry.getKey() + "=" + entry.getValue();
                    if (sb.length() + s.length() > limit && sb.length() > COMMENT_PREFIX.length()) {
                        System.out.println(sb.toString());
                        sb.delete(COMMENT_PREFIX.length(), sb.length());
                    }
                    sb.append(s);
                }
                System.out.println(sb.toString());
            }
        }
    }

    public void outputError(String error) {
        this.map.put("name", error);
        this.outputMap("error", this.map, 1);
        this.save(Resolution.getResolutionStopwatch().getCurrentCpuTime() / 1000L);
        OutputManager.printInfo(" mem = " + Tools.getFormattedUsedMemorySize());
    }

    private void addAttribute(int id_element, String attributeName, String attributeValue) {
        Element element = this.selectElementFrom(id_element);
        element.setAttribute(attributeName, attributeValue);
    }

    public void save(long totalDuration) {
        if (this.mode == 0) {
            return;
        }
        this.addAttribute(0, "totalWallClockTime", String.valueOf(totalDuration));
        String directoryName = ConfigurationManager.getString("//saveXMLOutputs", "dir");
        if (!directoryName.trim().equals("")) {
            File file = new File(directoryName = String.valueOf(directoryName) + File.separator + "results");
            if (!file.exists()) {
                file.mkdirs();
            }
            XMLManipulation.save(this.document, String.valueOf(directoryName) + File.separator + this.outputFileName);
        }
    }
}

