/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.constants.XMLInstanceRepresentation;
import java.util.Stack;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionBuilder {
    private static Document document;

    private static Element buildElement(String tagName, String attributeName, String attributeValue) {
        Element element = document.createElement(tagName);
        element.setAttribute(attributeName, attributeValue);
        return element;
    }

    private static Element buildElement(String tagName, Element child) {
        Element element = document.createElement(tagName);
        element.appendChild(child);
        return element;
    }

    private static Element buildElement(String tagName, Element child1, Element child2) {
        Element element = document.createElement(tagName);
        element.appendChild(child1);
        element.appendChild(child2);
        return element;
    }

    private static Element dealXMLWith(String token, Stack<Element> stack) {
        if (token.charAt(0) == 'y') {
            return ExpressionBuilder.buildElement("var", "name", token);
        }
        if (token.equals("neg")) {
            return ExpressionBuilder.buildElement("neg", stack.pop());
        }
        if (token.equals("abs")) {
            return ExpressionBuilder.buildElement("abs", stack.pop());
        }
        if (token.equals("not")) {
            return ExpressionBuilder.buildElement("not", stack.pop());
        }
        Element child1 = stack.pop();
        Element child2 = stack.pop();
        return ExpressionBuilder.buildElement(token, child2, child1);
    }

    public static Element buildXMLExpression(Document document, String expression) {
        ExpressionBuilder.document = document;
        Stack<Element> stack = new Stack<Element>();
        StringTokenizer st = new StringTokenizer(expression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toLowerCase();
            stack.add(ExpressionBuilder.dealXMLWith(token, stack));
        }
        assert (stack.size() == 1);
        return (Element)stack.pop();
    }

    private static String buildFunctionalToken(String token, Stack<String> stack) {
        if (Character.isDigit(token.charAt(token.length() - 1))) {
            return token;
        }
        if (token.equals("neg") || token.equals("abs") || token.equals("not")) {
            return String.valueOf(token) + "(" + stack.pop() + ")";
        }
        String s1 = stack.pop();
        String s2 = stack.pop();
        return String.valueOf(token) + "(" + s2 + "," + s1 + ")";
    }

    public static String buildFunctionalExpression(String postfixExpression) {
        Stack<String> stack = new Stack<String>();
        StringTokenizer st = new StringTokenizer(postfixExpression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            stack.add(ExpressionBuilder.buildFunctionalToken(token, stack));
        }
        assert (stack.size() == 1);
        return (String)stack.pop();
    }

    private static int getPositionOfFormalParameter(String[] formalParameters, String token) {
        int i = 0;
        while (i < formalParameters.length) {
            if (formalParameters[i].equals(token)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isInteger(String token) {
        try {
            Integer.parseInt(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String buildPostfixExpression(StringTokenizer st, String[] formalParameters, boolean[] found) {
        String token = st.nextToken();
        if (ExpressionBuilder.isInteger(token) || token.equals("true") || token.equals("false")) {
            return token;
        }
        int position = ExpressionBuilder.getPositionOfFormalParameter(formalParameters, token);
        if (position != -1) {
            found[position] = true;
            return XMLInstanceRepresentation.getParameterNameFor(position);
        }
        if (token.equals("neg") || token.equals("abs") || token.equals("not")) {
            return String.valueOf(ExpressionBuilder.buildPostfixExpression(st, formalParameters, found)) + " " + token;
        }
        return String.valueOf(ExpressionBuilder.buildPostfixExpression(st, formalParameters, found)) + " " + ExpressionBuilder.buildPostfixExpression(st, formalParameters, found) + " " + token;
    }

    public static String buildPostfixExpression(String functionalExpression, String[] formalParameters) {
        StringTokenizer st = new StringTokenizer(functionalExpression, "(), ");
        boolean[] found = new boolean[formalParameters.length];
        String postfixExpression = ExpressionBuilder.buildPostfixExpression(st, formalParameters, found);
        int i = 0;
        while (i < found.length) {
            if (!found[i]) {
                throw new IllegalArgumentException("One formal parameter not found in the given expression");
            }
            ++i;
        }
        return postfixExpression;
    }
}

