/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.xml.Core;
import java.util.LinkedList;

public class Cores {
    private LinkedList<Core> list = new LinkedList();

    public void add(int nbVariables, int nbConstraints) {
        this.list.add(new Core(nbVariables, nbConstraints));
    }

    public int getNbCores() {
        return this.list.size();
    }

    public void reset() {
        this.list.clear();
    }

    public Core getMin() {
        int bestIndex = 0;
        int bestNbVariables = this.list.get(0).getNbVariables();
        int bestNbConstraints = this.list.get(0).getNbConstraints();
        int i = 1;
        while (i < this.list.size()) {
            int nbVariables = this.list.get(i).getNbVariables();
            int nbConstraints = this.list.get(i).getNbConstraints();
            if (nbVariables < bestNbVariables || nbVariables == bestNbVariables && nbConstraints < bestNbConstraints) {
                bestIndex = i;
                bestNbVariables = nbVariables;
                bestNbConstraints = nbConstraints;
            }
            ++i;
        }
        return this.list.get(bestIndex);
    }

    public Core getMax() {
        int bestIndex = 0;
        int bestNbVariables = this.list.get(0).getNbVariables();
        int bestNbConstraints = this.list.get(0).getNbConstraints();
        int i = 1;
        while (i < this.list.size()) {
            int nbVariables = this.list.get(i).getNbVariables();
            int nbConstraints = this.list.get(i).getNbConstraints();
            if (nbVariables > bestNbVariables || nbVariables == bestNbVariables && nbConstraints > bestNbConstraints) {
                bestIndex = i;
                bestNbVariables = nbVariables;
                bestNbConstraints = nbConstraints;
            }
            ++i;
        }
        return this.list.get(bestIndex);
    }

    public Core getAvg() {
        int sumNbVariables = this.list.get(0).getNbVariables();
        int sumNbConstraints = this.list.get(0).getNbConstraints();
        int i = 1;
        while (i < this.list.size()) {
            int nbVariables = this.list.get(i).getNbVariables();
            int nbConstraints = this.list.get(i).getNbConstraints();
            sumNbVariables += nbVariables;
            sumNbConstraints += nbConstraints;
            ++i;
        }
        return new Core(sumNbVariables / this.list.size(), sumNbConstraints / this.list.size());
    }

    public Core getLast() {
        return this.list.getLast();
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.list.size()) {
            s = String.valueOf(s) + "Ker" + i + "=" + this.list.get(i) + (i < this.list.size() - 1 ? " " : "");
            ++i;
        }
        return s;
    }
}

