/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.reflection;

import abscon.tools.Tools;
import abscon.tools.reflection.Reflector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class Factory {
    private static Map<String, String> map = new HashMap<String, String>();

    public static Object getInstanceOf(String className) {
        try {
            Class<?> cn = Class.forName(className);
            if (Modifier.isAbstract(cn.getModifiers())) {
                throw new InstantiationException(String.valueOf(className) + "is abstract");
            }
            return cn.newInstance();
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
            return null;
        }
    }

    public static Object getInstanceOf(String className, Class rootClass) {
        String classPackageName = rootClass.getPackage().getName();
        String key = String.valueOf(classPackageName) + className;
        String absoluteClassName = map.get(key);
        if (absoluteClassName == null) {
            absoluteClassName = Reflector.searchAbsoluteNameOf(rootClass.getPackage().getName(), className);
            if (absoluteClassName == null) {
                throw new RuntimeException("Class " + className + " not found");
            }
            map.put(key, absoluteClassName);
        }
        try {
            Class<?> cn = Class.forName(absoluteClassName);
            Class<?> rcn = Class.forName(rootClass.getName());
            if (!rcn.isAssignableFrom(cn)) {
                throw new RuntimeException(String.valueOf(absoluteClassName) + " does not extend " + rootClass.getName());
            }
            if (Modifier.isAbstract(cn.getModifiers())) {
                throw new RuntimeException(String.valueOf(className) + " is abstract");
            }
            return cn.newInstance();
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
            return null;
        }
    }

    public static Object getInstanceOf(String className, Object[] objects) {
        try {
            Class<?> cn = Class.forName(className);
            Constructor<?>[] cs = cn.getConstructors();
            assert (cs.length == 1);
            return cs[0].newInstance(objects);
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
            return null;
        }
    }

    public static Object getArrayInstance(String className, int[] lengths) {
        try {
            Class<?> cn = Class.forName(className);
            return Array.newInstance(cn, lengths);
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
            return null;
        }
    }
}

