/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.math;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class LinearRegression {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int XY = 3;
    private static final int XX = 4;
    private Point2D[] observedPoints;
    private Point2D[] computedPoints;
    private double b0;
    private double b1;

    public LinearRegression(String fileName, int xColumn, int yColumn, int yBasis) throws IOException {
        LinkedList<Point2D.Double> list = new LinkedList<Point2D.Double>();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = in.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() == 0) continue;
            int i = 1;
            while (i < xColumn) {
                st.nextToken();
                ++i;
            }
            double x = Double.parseDouble(st.nextToken());
            int i2 = xColumn + 1;
            while (i2 < yColumn) {
                st.nextToken();
                ++i2;
            }
            double y = Double.parseDouble(st.nextToken());
            y = yBasis == 1 ? y : Math.log(y) / Math.log(yBasis);
            list.add(new Point2D.Double(x, y));
            line = in.readLine();
        }
        this.observedPoints = list.toArray(new Point2D.Double[0]);
    }

    private double computeSumOf(Point2D[] points, int mode) {
        double sum = 0.0;
        int i = 0;
        while (i < points.length) {
            if (mode == 0) {
                sum += points[i].getX();
            } else if (mode == 1) {
                sum += points[i].getY();
            } else if (mode == 4) {
                sum += points[i].getX() * points[i].getX();
            } else if (mode == 3) {
                sum += points[i].getX() * points[i].getY();
            }
            ++i;
        }
        return sum;
    }

    private void computeLineEquation() {
        double xSum = this.computeSumOf(this.observedPoints, 0);
        double ySum = this.computeSumOf(this.observedPoints, 1);
        double xyProduct = this.computeSumOf(this.observedPoints, 3);
        double x2Sum = this.computeSumOf(this.observedPoints, 4);
        double denominator = (double)this.observedPoints.length * x2Sum - xSum * xSum;
        this.b0 = (x2Sum * ySum - xSum * xyProduct) / denominator;
        this.b1 = ((double)this.observedPoints.length * xyProduct - xSum * ySum) / denominator;
        System.out.println("b0 = " + this.b0 + " b1 = " + this.b1);
    }

    private void buildComputedPoints() {
        this.computedPoints = new Point2D.Double[this.observedPoints.length];
        int i = 0;
        while (i < this.observedPoints.length) {
            this.computedPoints[i] = new Point2D.Double(this.observedPoints[i].getX(), this.b0 + this.b1 * this.observedPoints[i].getX());
            ++i;
        }
    }

    private void computeCorrelation() {
        double meanY = this.computeSumOf(this.observedPoints, 1) / (double)this.observedPoints.length;
        double sst = 0.0;
        int i = 0;
        while (i < this.observedPoints.length) {
            sst += (this.observedPoints[i].getY() - meanY) * (this.observedPoints[i].getY() - meanY);
            ++i;
        }
        this.buildComputedPoints();
        double sse = 0.0;
        int i2 = 0;
        while (i2 < this.computedPoints.length) {
            sse += (this.computedPoints[i2].getY() - meanY) * (this.computedPoints[i2].getY() - meanY);
            ++i2;
        }
        double ssr = 0.0;
        int i3 = 0;
        while (i3 < this.observedPoints.length) {
            ssr += (this.observedPoints[i3].getY() - this.computedPoints[i3].getY()) * (this.observedPoints[i3].getY() - this.computedPoints[i3].getY());
            ++i3;
        }
        System.out.println("sst =" + sst + " sse = " + sse + " ssr = " + ssr + " ssr+ssse=" + (ssr + sse));
        System.out.println("r2 = " + sse / sst);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: java abscon.tools.RegressionLinaire <fileName> <xColumn> <yColumn> <yBasis>");
            System.exit(1);
        }
        LinearRegression rl = new LinearRegression(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
        rl.computeLineEquation();
        rl.computeCorrelation();
    }
}

