/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.math;

public class LexicographicIterator {
    private int[] tuple;
    private int[] position;
    private int[][] domains;

    public LexicographicIterator(int[][] domains) {
        this.domains = domains;
        this.tuple = new int[domains.length];
        this.position = new int[domains.length];
    }

    public int[] getFirstTuple() {
        int i = 0;
        while (i < this.tuple.length) {
            this.tuple[i] = this.domains[i][0];
            this.position[i] = 0;
            ++i;
        }
        return this.tuple;
    }

    public int[] getNextTupleAfter(int[] tuple) {
        int i = tuple.length - 1;
        while (i >= 0) {
            if (this.position[i] < this.domains[i].length - 1) {
                int n = i;
                this.position[n] = this.position[n] + 1;
                tuple[i] = this.domains[i][this.position[i]];
                return tuple;
            }
            tuple[i] = this.domains[i][0];
            this.position[i] = 0;
            --i;
        }
        return null;
    }
}

