/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.math;

public class CompositionMaker {
    private static final int DEFAULT_MAX_VALUE = Integer.MAX_VALUE;

    public static long maxMax(int value1, int value2, int maxValue2) {
        if (value1 < 0 || value2 < 0 || value2 > maxValue2) {
            throw new IllegalArgumentException("value1=" + value1 + " value2=" + value2 + " maxValue2=" + maxValue2);
        }
        return (long)value1 * ((long)maxValue2 + 1L) + (long)value2;
    }

    public static long maxMax(int value1, int value2) {
        return CompositionMaker.maxMax(value1, value2, Integer.MAX_VALUE);
    }

    public static double maxMaxD(int value1, int value2, int maxValue2) {
        long l = CompositionMaker.maxMax(value1, value2, maxValue2);
        double d = l;
        assert (l == (long)d) : "Lost of information : l = " + l + " d = " + d;
        return d;
    }

    public static double maxMaxD(int value1, int value2) {
        return CompositionMaker.maxMaxD(value1, value2, Integer.MAX_VALUE);
    }

    public static long minMax(int value1, int maxValue1, int value2, int maxValue2) {
        if (value1 < 0) {
            throw new IllegalArgumentException("value1=" + value1);
        }
        return CompositionMaker.maxMax(maxValue1 - value1, value2, maxValue2);
    }

    public static long minMax(int value1, int value2) {
        return CompositionMaker.minMax(value1, Integer.MAX_VALUE, value2, Integer.MAX_VALUE);
    }

    public static double minMaxD(int value1, int maxValue1, int value2, int maxValue2) {
        long l = CompositionMaker.minMax(value1, maxValue1, value2, maxValue2);
        double d = l;
        assert (l == (long)d) : "Lost of information : l = " + l + " d = " + d;
        return d;
    }

    public static double minMaxD(int value1, int value2) {
        return CompositionMaker.minMaxD(value1, Integer.MAX_VALUE, value2, Integer.MAX_VALUE);
    }

    public static long minMin(int value1, int maxValue1, int value2, int maxValue2) {
        if (value1 < 0 || value2 < 0) {
            throw new IllegalArgumentException("value1=" + value1);
        }
        return CompositionMaker.maxMax(maxValue1 - value1, maxValue2 - value2, maxValue2);
    }

    public static long minMin(int value1, int value2) {
        return CompositionMaker.minMin(value1, Integer.MAX_VALUE, value2, Integer.MAX_VALUE);
    }

    public static double minMinD(int value1, int maxValue1, int value2, int maxValue2) {
        long l = CompositionMaker.minMin(value1, maxValue1, value2, maxValue2);
        double d = l;
        assert (l == (long)d) : "Lost of information : l = " + l + " d = " + d;
        return d;
    }

    public static double minMinD(int value1, int value2) {
        return CompositionMaker.minMinD(value1, Integer.MAX_VALUE, value2, Integer.MAX_VALUE);
    }

    public static long maxMin(int value1, int value2, int maxValue2) {
        if (value2 < 0) {
            throw new IllegalArgumentException("value1=" + value1);
        }
        return CompositionMaker.maxMax(value1, maxValue2 - value2, maxValue2);
    }

    public static long maxMin(int value1, int value2) {
        return CompositionMaker.maxMin(value1, value2, Integer.MAX_VALUE);
    }

    public static double maxMinD(int value1, int value2, int maxValue2) {
        long l = CompositionMaker.maxMin(value1, value2, maxValue2);
        double d = l;
        assert (l == (long)d) : "Lost of information : l = " + l + " d = " + d;
        return d;
    }

    public static double maxMinD(int value1, int value2) {
        return CompositionMaker.maxMinD(value1, value2, Integer.MAX_VALUE);
    }

    public static void main(String[] args) {
        long l2;
        long l1 = CompositionMaker.minMax(0, Integer.MAX_VALUE);
        if (l1 == (l2 = CompositionMaker.minMax(0, 0x7FFFFFFE))) {
            System.out.println("pb0");
        } else {
            System.out.println("l1=" + l1 + " l2=" + l2);
        }
        double d1 = CompositionMaker.minMaxD(0, Integer.MAX_VALUE);
        double d2 = CompositionMaker.minMaxD(0, 0x7FFFFFFE);
        if (d1 == d2) {
            System.out.println("pb1");
        } else {
            System.out.println("d1=" + d1 + " d2=" + d2);
        }
        long base = Integer.MAX_VALUE;
        System.out.println("base = " + base + " maxlong = " + Long.MAX_VALUE);
        long l = 0L;
        double d = 0.0;
        try {
            l = Integer.MAX_VALUE * (base + 1L) + Integer.MAX_VALUE;
            d = 2.147483647E9 * (double)(base + 1L) + 2.147483647E9;
        }
        catch (Throwable e) {
            System.out.println("pb" + l);
        }
        System.out.println("max = 2147483647 l=" + l + " d=" + d);
        double d3 = CompositionMaker.minMaxD(10, 5);
        double d4 = CompositionMaker.minMaxD(10, 4);
        if (d3 == d4) {
            System.out.println("pb3");
        }
    }
}

