/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.math;

public class BasisConvertor {
    private static boolean controlNumber(int[] number, int base) {
        int i = 0;
        while (i < number.length) {
            if (number[i] >= base) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean controlNumber(int[] number, int[] bases) {
        int i = 0;
        while (i < number.length) {
            if (number[i] >= bases[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static long getDecimalValueFor(int[] number, int base) {
        assert (BasisConvertor.controlNumber(number, base));
        double decimalValue = number[0];
        int i = 1;
        while (i < number.length) {
            decimalValue = decimalValue * (double)base + (double)number[i];
            ++i;
        }
        if (decimalValue > 9.223372036854776E18) {
            throw new IllegalArgumentException("The decimal value = " + decimalValue + "is too big to be represented by a long integer");
        }
        return (long)decimalValue;
    }

    public static long getDecimalValueFor(int[] number, int[] bases) {
        assert (BasisConvertor.controlNumber(number, bases));
        double decimalValue = number[0];
        int i = 1;
        while (i < number.length) {
            decimalValue = decimalValue * (double)bases[i] + (double)number[i];
            ++i;
        }
        if (decimalValue > 9.223372036854776E18) {
            throw new IllegalArgumentException("The decimal value = " + decimalValue + "is too big to be represented by a long integer");
        }
        return (long)decimalValue;
    }

    public static int[] getValueFor(long decimalValue, int[] value, int base) {
        int i = value.length - 1;
        while (i >= 0) {
            int digit;
            value[i] = digit = (int)(decimalValue % (long)base);
            decimalValue /= (long)base;
            --i;
        }
        if (decimalValue > 0L) {
            throw new IllegalArgumentException("The given array is too small to contain all the digits of the conversion");
        }
        return value;
    }

    public static int[] getValueFor(long decimalValue, int[] value, int[] bases) {
        int i = value.length - 1;
        while (i >= 0) {
            int digit;
            value[i] = digit = (int)(decimalValue % (long)bases[i]);
            decimalValue /= (long)bases[i];
            --i;
        }
        if (decimalValue > 0L) {
            throw new IllegalArgumentException("The given array is too small to contain all the digits of the conversion");
        }
        return value;
    }
}

