/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.exceptions.UnreachableCodeException;
import abscon.tools.elements.ExtensionElements;

public class LazyElements
extends ExtensionElements {
    public LazyElements(int size) {
        super(size);
    }

    public int getNextPresent(int element) {
        int prev = element;
        int next = this.nextPresents[prev];
        while (next != -1 && this.absentLevels[next] != -1) {
            prev = next;
            next = this.nextPresents[prev];
        }
        int i = element;
        while (i < prev) {
            this.nextPresents[i] = next;
            ++i;
        }
        return next;
    }

    public int getPrevPresent(int element) {
        int next = element;
        int prev = this.prevPresents[next];
        while (prev != -1 && this.absentLevels[prev] != -1) {
            next = prev;
            prev = this.prevPresents[next];
        }
        int i = element;
        while (i > next) {
            this.prevPresents[i] = prev;
            --i;
        }
        return prev;
    }

    public void addElement(int element) {
        throw new UnreachableCodeException();
    }

    public void restoreElementsAtLevelGreaterThanOrEqualTo(int level) {
        assert (this.lastAbsent == -1 || this.absentLevels[this.lastAbsent] <= level);
        int cpt = 0;
        int element = this.lastAbsent;
        while (element != -1) {
            if (this.absentLevels[element] < level) break;
            ++cpt;
            this.absentLevels[element] = -1;
            this.lastAbsent = this.prevAbsents[element];
            element = this.prevAbsents[element];
        }
        if (cpt != 0) {
            this.nbPresentElements += cpt;
            this.nbAbsentElements -= cpt;
            int prev = -1;
            int i = 0;
            while (i < this.prevPresents.length) {
                this.prevPresents[i] = prev;
                if (this.absentLevels[i] == -1) {
                    if (prev == -1) {
                        this.firstPresent = i;
                    }
                    prev = i;
                }
                ++i;
            }
            int next = -1;
            int i2 = this.nextPresents.length - 1;
            while (i2 >= 0) {
                this.nextPresents[i2] = next;
                if (this.absentLevels[i2] == -1) {
                    if (next == -1) {
                        this.lastPresent = i2;
                    }
                    next = i2;
                }
                --i2;
            }
        }
    }

    protected void removeElement(int element) {
        int prev = this.prevPresents[element];
        int next = this.nextPresents[element];
        if (prev == -1) {
            this.firstPresent = next;
        } else {
            this.nextPresents[prev] = next;
        }
        if (next == -1) {
            this.lastPresent = prev;
        } else {
            this.prevPresents[next] = prev;
        }
        this.prevAbsents[element] = this.lastAbsent;
        this.lastAbsent = element;
        assert (this.controlElements());
    }

    public void reduceTo(int element, int level) {
        int next;
        assert (level >= 0 && this.absentLevels[element] == -1);
        int i = this.firstPresent;
        while (i != element) {
            this.absentLevels[i] = level;
            this.prevAbsents[i] = this.lastAbsent;
            this.lastAbsent = i;
            this.prevPresents[i] = -1;
            next = this.nextPresents[i];
            this.nextPresents[i] = element;
            i = next;
        }
        i = this.nextPresents[element];
        while (i != -1) {
            this.absentLevels[i] = level;
            this.prevAbsents[i] = this.lastAbsent;
            this.lastAbsent = i;
            this.prevPresents[i] = element;
            next = this.nextPresents[i];
            this.nextPresents[i] = -1;
            i = next;
        }
        this.nbAbsentElements += this.nbPresentElements - 1;
        this.nbPresentElements = 1;
        this.prevPresents[element] = -1;
        this.nextPresents[element] = -1;
        this.firstPresent = element;
        this.lastPresent = element;
        assert (this.controlElements());
    }

    public boolean controlElements() {
        int j;
        int limit;
        if (!super.controlElements()) {
            return false;
        }
        int i = 0;
        while (i < this.nextPresents.length) {
            int next = this.nextPresents[i];
            if (next != -1 && next < i) {
                System.out.println("order of nextPresent incorrect :" + i + " is not before " + next);
                return false;
            }
            limit = next == -1 ? this.nextPresents.length : next;
            j = i + 1;
            while (j < limit) {
                if (this.absentLevels[j] == -1) {
                    System.out.println("bad next present " + j + " is present while " + limit + " was expected");
                    return false;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.prevPresents.length) {
            int prev = this.prevPresents[i];
            if (prev != -1 && prev > i) {
                System.out.println("order of prevPresent incorrect :" + prev + " is not after " + i);
                return false;
            }
            limit = prev == -1 ? -1 : prev;
            j = i - 1;
            while (j > limit) {
                if (this.absentLevels[j] == -1) {
                    System.out.println("bad prev present");
                    return false;
                }
                --j;
            }
            ++i;
        }
        return true;
    }
}

