/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.tools.elements.Elements;
import pseudo.Problem0;

public class BinaryElementsOld
extends Elements {
    protected int firstPresent;
    protected int lastPresent;
    protected int lastAbsent;
    private Problem0 pseudoProblem;
    private Variable variable;
    private int[] absentLevels;
    private byte[] absents;
    private byte nbAbsentElements;

    public int getFirstPresent() {
        return this.firstPresent;
    }

    public int getLastPresent() {
        return this.lastPresent;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
        this.pseudoProblem = (Problem0)variable.getProblem();
    }

    public int getLastAbsent() {
        return this.nbAbsentElements == 0 ? -1 : this.absents[this.nbAbsentElements - 1];
    }

    public BinaryElementsOld(int size) {
        super(size);
        assert (size == 2);
        this.absentLevels = new int[]{-1, -1};
        this.absents = new byte[2];
        this.firstPresent = 0;
        this.lastPresent = 1;
        this.lastAbsent = -1;
    }

    public int getMaximumSize() {
        return 2;
    }

    public int getNbPresentElements() {
        return 2 - this.nbAbsentElements;
    }

    public int getNbAbsentElements() {
        return this.nbAbsentElements;
    }

    public int getNbAbsentElementsAtDepth(int level) {
        throw new MissingImplementationException();
    }

    public int getNextPresent(int element) {
        if (element == 1) {
            return -1;
        }
        return this.absentLevels[1] == -1 ? 1 : -1;
    }

    public int getPrevPresent(int element) {
        if (element == 0) {
            return -1;
        }
        return this.absentLevels[0] == -1 ? 0 : -1;
    }

    public int getPrevAbsent(int element) {
        if (this.nbAbsentElements < 2) {
            return -1;
        }
        return this.absents[1] == element ? this.absents[0] : -1;
    }

    public int getLastAbsentLevel() {
        if (this.nbAbsentElements == 0) {
            return -1;
        }
        return this.absentLevels[this.absents[this.nbAbsentElements - 1]];
    }

    public int getAbsentLevelOf(int element) {
        return this.absentLevels[element];
    }

    public int[] getAbsentLevels() {
        return this.absentLevels;
    }

    public int initialize() {
        return this.getNbPresentElements();
    }

    public boolean isPresent(int element) {
        return this.absentLevels[element] == -1;
    }

    public void add(int element) {
        assert (this.absentLevels[element] != -1);
        this.absentLevels[element] = -1;
        this.nbAbsentElements = (byte)(this.nbAbsentElements - 1);
        if (this.nbAbsentElements == 1) {
            this.firstPresent = element;
            this.lastPresent = element;
        } else {
            this.firstPresent = 0;
            this.lastPresent = 1;
        }
    }

    public void remove(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1) : "level = " + level + " level = " + this.absentLevels[element];
        this.absentLevels[element] = level;
        this.absents[this.nbAbsentElements] = (byte)element;
        this.nbAbsentElements = (byte)(this.nbAbsentElements + 1);
        if (this.nbAbsentElements == 2) {
            this.firstPresent = -1;
            this.lastPresent = -1;
        } else {
            int pres;
            this.firstPresent = pres = element == 0 ? 1 : 0;
            this.lastPresent = pres;
        }
    }

    public void reduceTo(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1);
        if (this.nbAbsentElements == 1) {
            return;
        }
        this.remove(element == 0 ? 1 : 0, level);
    }

    public void restoreElementsAtLevelGreaterThanOrEqualTo(int level) {
        if (this.nbAbsentElements == 0) {
            return;
        }
        byte element = this.absents[this.nbAbsentElements - 1];
        if (this.absentLevels[element] < level) {
            return;
        }
        if (this.pseudoProblem != null) {
            this.pseudoProblem.updateMinBoundAfterAdding(this.variable, (int)element);
        }
        this.add(element);
        if (this.nbAbsentElements == 0) {
            return;
        }
        element = this.absents[this.nbAbsentElements - 1];
        if (this.absentLevels[element] < level) {
            return;
        }
        if (this.pseudoProblem != null) {
            this.pseudoProblem.updateMinBoundAfterAdding(this.variable, (int)element);
        }
        this.add(element);
    }

    public String getStringListOfPresentElements() {
        if (this.nbAbsentElements == 2) {
            return "";
        }
        if (this.nbAbsentElements == 1) {
            return String.valueOf(this.absents[0] == 0 ? 1 : 0);
        }
        return "0 1";
    }

    protected boolean controlElements() {
        return true;
    }
}

