/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.tools.elements.Elements;

public class BinaryElements
extends Elements {
    private static long[][] binaryCases = new long[][]{new long[1], {1L}, {2L}, {3L}};
    private int[] absentLevels;
    private byte nbAbsentElements;
    private byte lastAbsent;

    public int getFirstPresent() {
        if (this.absentLevels[0] == -1) {
            return 0;
        }
        if (this.absentLevels[1] == -1) {
            return 1;
        }
        return -1;
    }

    public int getLastPresent() {
        if (this.absentLevels[1] == -1) {
            return 1;
        }
        if (this.absentLevels[0] == -1) {
            return 0;
        }
        return -1;
    }

    public int getLastAbsent() {
        return this.lastAbsent;
    }

    public long[] getBinaryRepresentation() {
        if (this.nbAbsentElements == 0) {
            return binaryCases[3];
        }
        if (this.nbAbsentElements == 2) {
            return binaryCases[0];
        }
        if (this.absentLevels[1] == -1) {
            return binaryCases[2];
        }
        return binaryCases[1];
    }

    public BinaryElements(int size) {
        super(size);
        assert (size == 2);
        this.absentLevels = new int[]{-1, -1};
        this.lastAbsent = (byte)-1;
    }

    public int getMaximumSize() {
        return 2;
    }

    public int getNbPresentElements() {
        return 2 - this.nbAbsentElements;
    }

    public int getNbAbsentElements() {
        return this.nbAbsentElements;
    }

    public int getNbAbsentElementsAtDepth(int level) {
        return (this.absentLevels[0] == level ? 1 : 0) + (this.absentLevels[1] == level ? 1 : 0);
    }

    public int getNextPresent(int element) {
        if (element == 1) {
            return -1;
        }
        return this.absentLevels[1] == -1 ? 1 : -1;
    }

    public int getPrevPresent(int element) {
        if (element == 0) {
            return -1;
        }
        return this.absentLevels[0] == -1 ? 0 : -1;
    }

    public int getPrevAbsent(int element) {
        if (this.nbAbsentElements < 2 || element != this.lastAbsent) {
            return -1;
        }
        return this.lastAbsent == 0 ? 1 : 0;
    }

    public int getLastAbsentLevel() {
        return this.absentLevels[this.lastAbsent];
    }

    public int getAbsentLevelOf(int element) {
        return this.absentLevels[element];
    }

    public int[] getAbsentLevels() {
        return this.absentLevels;
    }

    public int initialize() {
        return this.getNbPresentElements();
    }

    public boolean isPresent(int element) {
        return this.absentLevels[element] == -1;
    }

    public void add(int element) {
        assert (this.absentLevels[element] != -1);
        this.absentLevels[element] = -1;
        this.nbAbsentElements = (byte)(this.nbAbsentElements - 1);
        this.lastAbsent = this.nbAbsentElements == 1 ? (byte)(element == 0 ? 1 : 0) : (byte)-1;
    }

    public void remove(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1) : "level = " + level + " level = " + this.absentLevels[element];
        this.absentLevels[element] = level;
        this.nbAbsentElements = (byte)(this.nbAbsentElements + 1);
        this.lastAbsent = (byte)element;
    }

    public void reduceTo(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1);
        if (this.nbAbsentElements == 1) {
            return;
        }
        this.remove(element == 0 ? 1 : 0, level);
    }

    public void restoreElementsAtLevelGreaterThanOrEqualTo(int level) {
        if (this.nbAbsentElements == 0) {
            return;
        }
        if (this.absentLevels[this.lastAbsent] < level) {
            return;
        }
        this.add(this.lastAbsent);
        if (this.nbAbsentElements == 0) {
            return;
        }
        if (this.absentLevels[this.lastAbsent] < level) {
            return;
        }
        this.add(this.lastAbsent);
    }

    public String getStringListOfPresentElements() {
        if (this.nbAbsentElements == 2) {
            return "";
        }
        if (this.nbAbsentElements == 1) {
            return String.valueOf(this.lastAbsent == 0 ? 1 : 0);
        }
        return "0 1";
    }

    protected boolean controlElements() {
        return true;
    }
}

