/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.absconParameters;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ArgumentsManager {
    private static int nbReadArguments;
    private static String[] commandLineArguments;
    private static String configurationFileName;
    private static int nbInstances;
    private static String packageName;
    private static Scanner scanner;
    private static Map<String, String> map;

    static {
        scanner = new Scanner(System.in);
        map = new HashMap<String, String>();
    }

    public static String getConfigurationFileName() {
        return configurationFileName;
    }

    public static void setNbInstances(int nb) {
        nbInstances = nb;
    }

    public static int getNbInstances() {
        return nbInstances;
    }

    public static String getPackageName() {
        return packageName;
    }

    public static void setArguments(String[] args) {
        commandLineArguments = args;
        configurationFileName = args[0];
        try {
            nbInstances = Integer.parseInt(args[1]);
            if (nbInstances == -1) {
                nbInstances = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("The number of instances must be an integer  (" + args[1] + " is not valid )");
            System.exit(1);
        }
        packageName = args[2];
        nbReadArguments = 3;
    }

    private static boolean hasMoreArguments() {
        return nbReadArguments < commandLineArguments.length;
    }

    public static String getParameter(String key, String message) {
        String value = map.get(key);
        if (value == null) {
            if (ArgumentsManager.hasMoreArguments()) {
                value = commandLineArguments[nbReadArguments++];
            } else {
                System.out.print(message);
                value = scanner.next();
            }
            map.put(key, value);
        }
        return value;
    }

    public static void setParameter(String key, String message) {
        map.put(key, message);
    }

    public static int getIntParameter(String key, String message, int inf, int sup) {
        String value = ArgumentsManager.getParameter(key, message);
        try {
            int i = Integer.parseInt(value);
            if (i < inf || i > sup) {
                throw new IllegalArgumentException("(outside valid range)");
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + " " + message);
            System.exit(1);
            return 0;
        }
    }

    public static long getLongParameter(String key, String message, long inf, long sup) {
        String value = ArgumentsManager.getParameter(key, message);
        try {
            long i = Long.parseLong(value);
            if (i < inf || i > sup) {
                throw new IllegalArgumentException("(outside valid range)");
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + " " + message);
            System.exit(1);
            return 0L;
        }
    }

    public static boolean getBooleanParameter(String key, String message) {
        String value = ArgumentsManager.getParameter(key, message).toLowerCase();
        return value.equals("yes") || value.equals("y") || value.equals("1");
    }

    public static double getDoubleParameter(String key, String message, double inf, double sup) {
        String value = ArgumentsManager.getParameter(key, message);
        try {
            double i = Double.parseDouble(value);
            if (i < inf || i > sup) {
                throw new IllegalArgumentException("(outside valid range)");
            }
            return i;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + " " + message);
            System.exit(1);
            return 0.0;
        }
    }
}

