/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

import java.lang.management.ManagementFactory;

public class Stopwatch {
    private boolean cpuTimeSupported = ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported();
    private long startCpuTime;
    private long endCpuTime;
    private long startWallClockTime;
    private long endWallClockTime;

    public Stopwatch() {
        this.start();
    }

    private long computeCpuTime() {
        return ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1000000L;
    }

    public void start() {
        this.startWallClockTime = System.currentTimeMillis();
        if (this.cpuTimeSupported) {
            this.startCpuTime = this.computeCpuTime();
        }
    }

    public void stop() {
        this.endWallClockTime = System.currentTimeMillis();
        this.endCpuTime = this.computeCpuTime();
    }

    public long getCurrentWallClockTime() {
        return System.currentTimeMillis() - this.startWallClockTime;
    }

    public long getCurrentCpuTime() {
        return this.cpuTimeSupported ? this.computeCpuTime() - this.startCpuTime : -1L;
    }

    public long getStoppedWallClockTime() {
        return this.endWallClockTime - this.startWallClockTime;
    }

    public long getStoppedCpuTime() {
        return this.cpuTimeSupported ? this.endCpuTime - this.startCpuTime : -1L;
    }
}

