/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

import abscon.constraints.Constraint;
import abscon.tools.ConnexComponent;
import java.util.LinkedList;
import java.util.List;

public class ConstraintConnexComponents {
    private List<ConnexComponent> classes = new LinkedList<ConnexComponent>();
    private boolean linkedMode;

    public ConstraintConnexComponents(boolean linkedMode) {
        this.linkedMode = linkedMode;
    }

    private void dealTuple(int[] tuple) {
        int lastFoundId = -1;
        ConnexComponent[] ccs = this.classes.toArray(new ConnexComponent[0]);
        int i = 0;
        while (i < ccs.length) {
            if (!this.linkedMode && ccs[i].isThereATupleConnectedTo(tuple)) {
                if (lastFoundId == -1) {
                    ccs[i].add(tuple);
                    lastFoundId = i;
                } else {
                    ccs[lastFoundId].merge(ccs[i]);
                    this.classes.remove(ccs[i]);
                }
            }
            ++i;
        }
        if (lastFoundId == -1) {
            this.classes.add(new ConnexComponent(tuple));
        }
    }

    public void determineConnexComponentOf(Constraint constraint) {
        constraint.getTupleManager().setFirstTupleFromScratch();
        do {
            if (!constraint.checkCurrentTupleOfAssistant()) continue;
            this.dealTuple((int[])constraint.getTupleManager().getCurrentTuple().clone());
        } while (constraint.getTupleManager().setNextTuple() != -1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("There are " + this.classes.size() + " Connex Components:\n");
        for (ConnexComponent cc : this.classes) {
            sb.append(cc.toString());
        }
        sb.append("\n");
        return sb.toString();
    }
}

