/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

public class BitManager {
    public static final int BYTE_SIZE = 8;
    public static final int SHORT_SIZE = 16;
    public static final int INT_SIZE = 32;
    public static final int LONG_SIZE = 64;
    public static final short ALL_SHORT_BITS_TO_1 = -1;
    public static final int ALL_INT_BITS_TO_1 = -1;
    public static final long ALL_LONG_BITS_TO_1 = -1L;
    public static final byte[] ONE_BYTE_BIT_TO_0 = BitManager.buildOneByteBitTo0();
    public static final int[] ONE_INT_BIT_TO_0 = BitManager.buildOneIntBitTo0();
    public static final long[] ONE_LONG_BIT_TO_0 = BitManager.buildOneLongBitTo0();
    public static final byte[] ONE_BYTE_BIT_TO_1 = BitManager.buildOneByteBitTo1();
    public static final short[] ONE_SHORT_BIT_TO_1 = BitManager.buildOneShortBitTo1();
    public static final int[] ONE_INT_BIT_TO_1 = BitManager.buildOneIntBitTo1();
    public static final long[] ONE_LONG_BIT_TO_1 = BitManager.buildOneLongBitTo1();

    private static byte[] buildOneByteBitTo0() {
        byte[] t = new byte[8];
        t[7] = 127;
        int current = -65;
        int i = 6;
        while (i >= 0) {
            t[i] = current;
            current = (byte)(current >> 1);
            --i;
        }
        return t;
    }

    private static int[] buildOneIntBitTo0() {
        int[] t = new int[32];
        t[31] = Integer.MAX_VALUE;
        int current = -1073741825;
        int i = 30;
        while (i >= 0) {
            t[i] = current;
            current >>= 1;
            --i;
        }
        return t;
    }

    private static long[] buildOneLongBitTo0() {
        long[] t = new long[64];
        t[63] = Long.MAX_VALUE;
        long current = -4611686018427387905L;
        int i = 62;
        while (i >= 0) {
            t[i] = current;
            current >>= 1;
            --i;
        }
        return t;
    }

    private static byte[] buildOneByteBitTo1() {
        byte[] t = new byte[8];
        byte current = 1;
        int i = 0;
        while (i < t.length) {
            t[i] = current;
            current = (byte)(current << 1);
            ++i;
        }
        return t;
    }

    private static short[] buildOneShortBitTo1() {
        short[] t = new short[16];
        short current = 1;
        int i = 0;
        while (i < t.length) {
            t[i] = current;
            current = (short)(current << 1);
            ++i;
        }
        return t;
    }

    private static int[] buildOneIntBitTo1() {
        int[] t = new int[32];
        int current = 1;
        int i = 0;
        while (i < t.length) {
            t[i] = current;
            current <<= 1;
            ++i;
        }
        return t;
    }

    private static long[] buildOneLongBitTo1() {
        long[] t = new long[64];
        long current = 1L;
        int i = 0;
        while (i < t.length) {
            t[i] = current;
            current <<= 1;
            ++i;
        }
        return t;
    }

    public static boolean isIncluded(long[] t1, long[] t2) {
        assert (t1.length == t2.length);
        int i = 0;
        while (i < t1.length) {
            if ((t1[i] | t2[i]) != t2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPresent(long[] t, int index) {
        return (t[index / 64] & ONE_LONG_BIT_TO_1[index % 64]) != 0L;
    }

    public static int buildAllIntBitsTo1Upto(int limit) {
        int v = 0;
        int i = 0;
        while (i < limit) {
            v |= ONE_INT_BIT_TO_1[i];
            ++i;
        }
        return v;
    }

    public static long buildAllLongBitsTo1Upto(int limit) {
        long v = 0L;
        int i = 0;
        while (i < limit) {
            v |= ONE_LONG_BIT_TO_1[i];
            ++i;
        }
        return v;
    }

    public static void setTo0(byte[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 8;
        t[n] = (byte)(t[n] & ONE_BYTE_BIT_TO_0[bitPosition % 8]);
    }

    public static void setTo1(byte[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 8;
        t[n] = (byte)(t[n] | ONE_BYTE_BIT_TO_1[bitPosition % 8]);
    }

    public static boolean isTo1(byte[] t, int bitPosition) {
        int bytePosition = bitPosition / 8;
        return (t[bytePosition] & ONE_BYTE_BIT_TO_1[bitPosition % 8]) != 0;
    }

    public static String decrypt(short v, int limit) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < limit) {
            sb.append((v & ONE_SHORT_BIT_TO_1[i]) != 0 ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static String decrypt(short v) {
        return BitManager.decrypt(v, 16);
    }

    public static String decrypt(char v) {
        return BitManager.decrypt((short)v);
    }

    public static String decrypt(int v, int limit) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < limit) {
            sb.append((v & ONE_INT_BIT_TO_1[i]) != 0 ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static String decrypt(int v) {
        return BitManager.decrypt(v, 32);
    }

    public static String decrypt(long v, int limit) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < limit) {
            sb.append((v & ONE_LONG_BIT_TO_1[i]) != 0L ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static String decrypt(long v) {
        return BitManager.decrypt(v, 64);
    }

    public static String decrypt(long[] t, int globalLimit) {
        StringBuffer sb = new StringBuffer();
        long[] lArray = t;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            if (globalLimit <= 0) break;
            sb.append(BitManager.decrypt(l, Math.min(globalLimit, 64)));
            globalLimit -= 64;
            ++n;
        }
        return sb.toString();
    }

    public static String decrypt(long[] t) {
        return BitManager.decrypt(t, 64);
    }

    public static void convert(int v, boolean twoCharacters, StringBuffer sb) {
        sb.append((char)v);
        if (twoCharacters) {
            sb.append((char)v >> 16);
        }
    }

    public static void convert(long[] t, int globalLimit, StringBuffer sb) {
        long[] lArray = t;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            int cnt = 0;
            while (cnt < 4) {
                if (globalLimit <= 0) {
                    return;
                }
                sb.append((char)l);
                l >>= 16;
                globalLimit -= 16;
                ++cnt;
            }
            ++n;
        }
    }

    public static int convert(int v, int nbBytesToCopy, byte[] buffer, int position) {
        int i = 0;
        while (i < nbBytesToCopy) {
            buffer[position++] = (byte)v;
            v >>= 8;
            ++i;
        }
        return position;
    }

    public static int convert(long[] t, int nbBitsToCopy, byte[] buffer, int position) {
        long[] lArray = t;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            int cnt = 0;
            while (cnt < 8) {
                if (nbBitsToCopy <= 0) {
                    return position;
                }
                buffer[position++] = (byte)l;
                l >>= 8;
                nbBitsToCopy -= 8;
                ++cnt;
            }
            ++n;
        }
        return position;
    }

    public static int copy(long[] t, int nbBitsToCopy, byte[] buffer, int globalFirstFreeBitPosition) {
        int hole;
        int bytePosition = globalFirstFreeBitPosition / 8;
        int bitPosition = globalFirstFreeBitPosition % 8;
        int n = hole = bitPosition == 0 ? 0 : 8 - bitPosition;
        if (nbBitsToCopy <= hole) {
            buffer[bytePosition] = (byte)(buffer[bytePosition] | (byte)(t[0] << bitPosition));
            return globalFirstFreeBitPosition + nbBitsToCopy;
        }
        int i = 0;
        int j = 0;
        long l = 0L;
        boolean fullByteCopyfinished = false;
        while (!fullByteCopyfinished && i < t.length) {
            l = t[i];
            j = 0;
            while (!fullByteCopyfinished && j < 8) {
                if (nbBitsToCopy <= 8 + hole) {
                    fullByteCopyfinished = true;
                }
                buffer[bytePosition++] = (byte)l;
                l >>= 8;
                nbBitsToCopy -= 8;
                ++j;
            }
            ++i;
        }
        int nbCopiedBytes = bytePosition - globalFirstFreeBitPosition / 8;
        bytePosition = globalFirstFreeBitPosition / 8;
        buffer[bytePosition] = (byte)(buffer[bytePosition] | (byte)(l << bitPosition));
        nbBitsToCopy -= hole;
        return 0;
    }
}

