/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.variableManagers;

import abscon.problem.Variable;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import abscon.tools.elements.GeneralElements;
import abscon.tools.elements.StackElements;

public class GlobalVariableManager
extends VariableManager {
    private int[] positions;
    private Elements elements;

    public GlobalVariableManager(Variable[] variables, int[] positions) {
        super(variables);
        this.positions = positions;
        int elems = ConfigurationManager.getInt(variables[0].getProblem().getLevelInResolution(), "problem/elements", "type");
        this.elements = elems == 0 ? new StackElements(variables.length) : new GeneralElements(variables.length);
    }

    public GlobalVariableManager(Variable[] variables) {
        this(variables, null);
        this.positions = new int[variables.length];
        int i = 0;
        while (i < this.positions.length) {
            this.positions[i] = i;
            ++i;
        }
    }

    public int getNbPastVariables() {
        return this.elements.getNbAbsentElements();
    }

    public Variable getLastPastVariable() {
        int element = this.elements.getLastAbsent();
        return element == -1 ? null : this.variables[element];
    }

    public Variable getPrevPastVariableBefore(Variable variable) {
        int element = this.elements.getPrevAbsent(this.positions[variable.getId()]);
        return element == -1 ? null : this.variables[element];
    }

    public Variable getFirstFutureVariable() {
        return this.getFirstFutureVariableFrom(this.elements.getFirstPresent());
    }

    private Variable getFirstFutureVariableFrom(int firstPosition) {
        int position = firstPosition;
        while (position != -1) {
            if (!this.variables[position].isDisconnected()) {
                return this.variables[position];
            }
            position = this.elements.getNextPresent(position);
        }
        return null;
    }

    public Variable getNextFutureVariableAfter(Variable variable) {
        assert (variable.isFuture() || variable.isDisconnected());
        return this.getFirstFutureVariableFrom(this.elements.getNextPresent(this.positions[variable.getId()]));
    }

    public int getAssignmentDepthOf(Variable variable) {
        assert (variable.isAssigned());
        return this.elements.getAbsentLevelOf(this.positions[variable.getId()]);
    }

    public void doAPastVariableOf(Variable variable) {
        this.elements.remove(this.positions[variable.getId()], this.getNbPastVariables() + 1);
    }

    public void undoAPastVariableOf(Variable variable) {
        this.elements.addPotentiallyIntermediate(this.positions[variable.getId()]);
    }

    public void displayPastVariables() {
        System.out.print(" There are " + this.getNbPastVariables() + " past variables =>");
        Variable variable = this.getLastPastVariable();
        while (variable != null) {
            System.out.print(" " + variable.getId());
            variable = this.getPrevPastVariableBefore(variable);
        }
        System.out.println();
    }

    public void displayFutureVariables() {
        System.out.print(" There are " + this.getNbFutureVariables() + " futures variables =>");
        Variable variable = this.getFirstFutureVariable();
        while (variable != null) {
            System.out.print(" " + variable.getId());
            variable = this.getNextFutureVariableAfter(variable);
        }
        System.out.println();
    }
}

