/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.BitManager;
import abscon.tools.Tools;
import abscon.tools.elements.Elements;
import abscon.xml.OutputManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;

public class SolutionCounter {
    private int checkStep = 50;
    private int memoryLimit = 600000000;
    private int keyCompressionLimit = 300;
    private static Integer zero = new Integer(0);
    private SystematicSolver solver;
    private Variable[] variables;
    private Map<HashKey, Integer> mapOfHashKeys = new HashMap<HashKey, Integer>(2000);
    private HashKey[] currentOpenNodesKeys;
    private int[] currentOpenNodesNbFoundSolutions;
    private boolean moreThanOneSolution;
    private int nbBytesPerVariableId;
    private boolean stop = false;
    private Deflater compressor;
    private byte[] tmpInput = new byte[50000];
    private byte[] tmpOutput = new byte[20000];
    private int nbTooLargeKeys;
    private int nbInferences;
    private int nbInferredSolutions;
    private boolean isGACGuaranteed;
    private HashKey currentHashKey;
    private int[] tmp;
    private int[][] dependencies;
    private int cnt = 0;

    public int getNbInferences() {
        return this.nbInferences;
    }

    public int getNbInferredSolutions() {
        return this.nbInferredSolutions;
    }

    public int getNbTooLargeKeys() {
        return this.nbTooLargeKeys;
    }

    public int getMapSize() {
        return this.mapOfHashKeys.size();
    }

    public boolean isStopped() {
        return this.stop;
    }

    public void clear() {
        this.mapOfHashKeys.clear();
    }

    private boolean initializeGACGuaranteed() {
        if (this.solver.getPreproPropagationTechnique() != null && !(this.solver.getPreproPropagationTechnique() instanceof ArcConsistency)) {
            return false;
        }
        if (this.solver.getSearchPropagationTechnique() != null && !(this.solver.getSearchPropagationTechnique() instanceof ArcConsistency)) {
            return false;
        }
        Constraint[] constraintArray = this.solver.getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!constraint.isGACGuaranteed()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void buildS() {
        if (this.solver.getProblem().getMaxConstraintArity() == 2) {
            return;
        }
        this.tmp = new int[this.solver.getNbVariables()];
        this.dependencies = new int[this.solver.getNbVariables()][];
        Variable[] variableArray = this.solver.getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            int nbDependencies = 0;
            Arrays.fill(this.tmp, 0);
            Constraint[] constraintArray = variable.getInvolvingConstraints();
            int n3 = 0;
            int n4 = constraintArray.length;
            while (n3 < n4) {
                Constraint involvingConstraint = constraintArray[n3];
                if (involvingConstraint.getArity() != 2) {
                    Variable[] variableArray2 = involvingConstraint.getInvolvedVariables();
                    int n5 = 0;
                    int n6 = variableArray2.length;
                    while (n5 < n6) {
                        Variable involvedVariable = variableArray2[n5];
                        if (involvedVariable != variable) {
                            int n7 = involvedVariable.getId();
                            this.tmp[n7] = this.tmp[n7] + 1;
                            if (this.tmp[involvedVariable.getId()] == 2) {
                                ++nbDependencies;
                            }
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            int[] t = new int[nbDependencies];
            int cpt = 0;
            int i = 0;
            while (i < this.tmp.length) {
                if (cpt == nbDependencies) break;
                if (this.tmp[i] > 1) {
                    t[cpt++] = i;
                }
                ++i;
            }
            this.dependencies[variable.getId()] = t;
            ++n;
        }
        int i = 0;
        while (i < this.dependencies.length) {
            System.out.print("dependencies of " + this.solver.getVariable(i) + " : ");
            int j = 0;
            while (j < this.dependencies[i].length) {
                System.out.print(this.solver.getVariable(this.dependencies[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public SolutionCounter(SystematicSolver solver, int compressionMode) {
        this.solver = solver;
        this.variables = solver.getVariables();
        this.isGACGuaranteed = this.initializeGACGuaranteed();
        this.currentOpenNodesKeys = new HashKey[this.variables.length];
        this.currentOpenNodesNbFoundSolutions = new int[this.variables.length];
        boolean bl = this.moreThanOneSolution = solver.getNbSearchedSolutions() > 1;
        int n = (double)this.variables.length <= Math.pow(2.0, 8.0) ? 1 : ((double)this.variables.length <= Math.pow(2.0, 16.0) ? 2 : (this.nbBytesPerVariableId = (double)this.variables.length <= Math.pow(2.0, 24.0) ? 3 : 4));
        if (compressionMode != 1) {
            this.compressor = new Deflater();
            this.compressor.setLevel(compressionMode == 2 ? 1 : 9);
        }
    }

    private byte[] compress(int limit) {
        assert (limit >= this.keyCompressionLimit);
        this.compressor.reset();
        this.compressor.setInput(this.tmpInput, 0, limit);
        this.compressor.finish();
        int count = this.compressor.deflate(this.tmpOutput);
        if (!this.compressor.finished()) {
            byte[] t = new byte[limit];
            System.arraycopy(this.tmpInput, 0, t, 0, limit);
            return t;
        }
        byte[] t = new byte[count];
        System.arraycopy(this.tmpOutput, 0, t, 0, count);
        return t;
    }

    private boolean canEliminateSingleton(Variable variable) {
        if (!this.isGACGuaranteed) {
            return false;
        }
        if (this.solver.getProblem().getMaxConstraintArity() == 2) {
            return true;
        }
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint involvingConstraint = constraintArray[n];
            if (involvingConstraint.getNbFreeVariables() > 1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void buildHashKey() {
        int keySize = 0;
        VariableManager variableManager = this.solver.getVariableManager();
        if (this.moreThanOneSolution) {
            Variable variable = variableManager.getFirstFutureVariable();
            while (keySize != -1 && variable != null) {
                Elements elements = variable.getDomain().getElements();
                if (elements.getNbPresentElements() != 1 || !this.canEliminateSingleton(variable)) {
                    if (keySize + this.nbBytesPerVariableId + elements.getMaximumSize() / 8 >= this.tmpInput.length) {
                        keySize = -1;
                    } else {
                        keySize = BitManager.convert(variable.getId(), this.nbBytesPerVariableId, this.tmpInput, keySize);
                        if (elements.getNbPresentElements() != elements.getMaximumSize()) {
                            keySize = BitManager.convert(elements.getBinaryRepresentation(), elements.getMaximumSize(), this.tmpInput, keySize);
                        }
                    }
                }
                variable = variableManager.getNextFutureVariableAfter(variable);
            }
        } else {
            Variable variable;
            if (this.solver.getProblem().getMaxConstraintArity() == 2) {
                variable = variableManager.getFirstFutureVariable();
                while (keySize != -1 && variable != null) {
                    Elements elements = variable.getDomain().getElements();
                    if (!(elements.getNbPresentElements() == elements.getMaximumSize() || elements.getNbPresentElements() == 1 && this.canEliminateSingleton(variable))) {
                        if (keySize + this.nbBytesPerVariableId + elements.getMaximumSize() / 8 >= this.tmpInput.length) {
                            keySize = -1;
                        } else {
                            keySize = BitManager.convert(variable.getId(), this.nbBytesPerVariableId, this.tmpInput, keySize);
                            keySize = BitManager.convert(elements.getBinaryRepresentation(), elements.getMaximumSize(), this.tmpInput, keySize);
                        }
                    }
                    variable = variableManager.getNextFutureVariableAfter(variable);
                }
            } else {
                Variable[] variableArray = this.solver.getVariables();
                int n = 0;
                int n2 = variableArray.length;
                while (n < n2) {
                    variable = variableArray[n];
                    Elements elements = variable.getDomain().getElements();
                    if (!(elements.getNbPresentElements() == elements.getMaximumSize() || elements.getNbPresentElements() == 1 && this.canEliminateSingleton(variable))) {
                        if (keySize + this.nbBytesPerVariableId + elements.getMaximumSize() / 8 >= this.tmpInput.length) {
                            keySize = -1;
                        } else {
                            keySize = BitManager.convert(variable.getId(), this.nbBytesPerVariableId, this.tmpInput, keySize);
                            keySize = BitManager.convert(elements.getBinaryRepresentation(), elements.getMaximumSize(), this.tmpInput, keySize);
                        }
                    }
                    ++n;
                }
            }
            if (this.currentHashKey == null) {
                this.currentHashKey = new HashKey();
            }
            if (keySize == -1) {
                this.currentHashKey.t = null;
                ++this.nbTooLargeKeys;
            } else {
                byte[] t = null;
                if (this.compressor == null || keySize < this.keyCompressionLimit) {
                    t = new byte[keySize];
                    System.arraycopy(this.tmpInput, 0, t, 0, keySize);
                } else {
                    t = this.compress(keySize);
                }
                this.currentHashKey.t = t;
            }
        }
    }

    public boolean dealWhenOpeningNode() {
        if (this.stop) {
            return true;
        }
        int level = this.solver.getCurrentDepth();
        if (level == this.variables.length) {
            return true;
        }
        this.buildHashKey();
        if (this.currentHashKey.t == null) {
            this.currentOpenNodesKeys[level] = null;
            return true;
        }
        Integer value = this.mapOfHashKeys.get(this.currentHashKey);
        if (value != null) {
            ++this.nbInferences;
            if (value > 0) {
                this.nbInferredSolutions += value.intValue();
                this.solver.getStatistics().incrementNbFoundSolutionsOf(value);
            } else {
                this.mapOfHashKeys.put(this.currentHashKey, value - 1);
            }
            return false;
        }
        this.currentOpenNodesKeys[level] = this.currentHashKey;
        this.currentHashKey = null;
        this.currentOpenNodesNbFoundSolutions[level] = (int)this.solver.getStatistics().getNbFoundSolutions();
        return true;
    }

    private boolean mustStopHyperNogood() {
        if (++this.cnt % this.checkStep != 0) {
            return false;
        }
        if (Tools.getUsedMemory() > (long)this.memoryLimit) {
            return true;
        }
        int nbGlobalKeys = this.mapOfHashKeys.size() + this.nbTooLargeKeys;
        return nbGlobalKeys > 1000 && nbGlobalKeys > 200 * this.nbInferences;
    }

    public void dealWhenClosingNode() {
        if (this.stop) {
            return;
        }
        if (this.mustStopHyperNogood()) {
            OutputManager.printInfo("Stopping hyperNogood (mapSize=" + this.mapOfHashKeys.size() + ", nbTooLargekeys=" + this.nbTooLargeKeys + ", mem=" + Tools.getFormattedUsedMemorySize() + ")");
            this.mapOfHashKeys.clear();
            this.stop = true;
            return;
        }
        HashKey hashKey = this.currentOpenNodesKeys[this.solver.getCurrentDepth()];
        if (hashKey == null) {
            return;
        }
        int nbSolutions = (int)this.solver.getStatistics().getNbFoundSolutions() - this.currentOpenNodesNbFoundSolutions[this.solver.getCurrentDepth()];
        this.mapOfHashKeys.put(hashKey, nbSolutions == 0 ? zero : nbSolutions);
    }

    public void display() {
        System.out.println(String.valueOf(OutputManager.COMMENT_PREFIX) + OutputManager.DATA_SEPARATOR + "mapSize=" + this.mapOfHashKeys.size() + OutputManager.DATA_SEPARATOR + "nbInferences=" + this.nbInferences + OutputManager.DATA_SEPARATOR + "nbInferredSolutions=" + this.nbInferredSolutions + " usedMem=" + Tools.getFormattedUsedMemorySize() + OutputManager.DATA_SEPARATOR + "nbTooLargeKeys=" + this.nbTooLargeKeys);
    }

    class HashKey {
        byte[] t;

        HashKey() {
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((HashKey)object).t);
        }
    }
}

