/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.systematicSolvers.HyperNogood;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.BitManager;
import abscon.tools.elements.Elements;

public class HyperNogoodManager {
    private SystematicSolver solver;
    private Variable[] variables;
    private HyperNogood[] waitingNogoods;
    private PropagationSet set;
    private int nbTotalRemovals;
    private int nbWipeout;
    private int nbHyperNogoods;
    private WatchCell[] watches;
    private WatchCell free;
    private int[] tmpVariable;
    private long[][] tmpDomain;
    private int cpt = 0;

    private void addWatch(HyperNogood hyperNogood, int watchPosition, int variablePosition) {
        int variableId = hyperNogood.variableIndices[variablePosition];
        if (this.free == null) {
            this.watches[variableId] = new WatchCell(hyperNogood, this.watches[variableId]);
        } else {
            WatchCell cell = this.free;
            this.free = this.free.nextCell;
            cell.hyperNogood = hyperNogood;
            cell.nextCell = this.watches[variableId];
            this.watches[variableId] = cell;
        }
        hyperNogood.watchedVariablePositions[watchPosition] = variablePosition;
    }

    public void moveWaitingNogoodFrom(int level) {
        if (level == 0) {
            return;
        }
        HyperNogood hyperNogood = this.waitingNogoods[level];
        if (hyperNogood == null) {
            System.out.println("pb");
        }
        if (hyperNogood.variableIndices.length == 0) {
            System.out.println("hyper nogood of size 0");
            this.solver.setFullExploration(true);
        } else if (hyperNogood.variableIndices.length == 1) {
            System.out.println("hyper nogood of size 1");
        } else {
            this.addWatch(hyperNogood, 0, 0);
            this.addWatch(hyperNogood, 1, hyperNogood.variableIndices.length - 1);
            ++this.nbHyperNogoods;
        }
    }

    public HyperNogoodManager(SystematicSolver solver) {
        this.solver = solver;
        this.variables = solver.getVariables();
        this.waitingNogoods = new HyperNogood[solver.getNbVariables() + 1];
        this.tmpVariable = new int[solver.getNbVariables()];
        this.tmpDomain = new long[solver.getNbVariables()][];
        this.watches = new WatchCell[solver.getNbVariables()];
        this.set = solver.getSearchPropagationTechnique().getPropagationSet();
    }

    public void putAtLevel(int level) {
        Variable[] variables;
        int cpt = 0;
        Variable[] variableArray = variables = this.solver.getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            Elements elements = variable.getDomain().getElements();
            if (elements.getNbPresentElements() != 1 && elements.getNbPresentElements() != elements.getMaximumSize()) {
                this.tmpVariable[cpt] = variable.getId();
                this.tmpDomain[cpt] = elements.getBinaryRepresentation();
                ++cpt;
            }
            ++n;
        }
        int[] variableIndices = new int[cpt];
        System.arraycopy(this.tmpVariable, 0, variableIndices, 0, cpt);
        long[][] domainRepresentations = new long[cpt][];
        int i = 0;
        while (i < cpt) {
            domainRepresentations[i] = (long[])this.tmpDomain[i].clone();
            ++i;
        }
        this.waitingNogoods[level] = new HyperNogood(variableIndices, domainRepresentations);
    }

    private boolean canFindAnotherWatch(HyperNogood hyperNogood, int watchPosition) {
        int[] variableIndices = hyperNogood.variableIndices;
        int i = 0;
        while (i < variableIndices.length) {
            long[] currentDomainRepresentation;
            if (!hyperNogood.isWatched(variableIndices[i]) && !BitManager.isIncluded(currentDomainRepresentation = this.variables[variableIndices[i]].getDomain().getElements().getBinaryRepresentation(), hyperNogood.getDomainRepresentationOfVariableAtPosition(i))) {
                this.addWatch(hyperNogood, watchPosition, i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean dealWithInference(Variable variable, long[] domainRepresentation) {
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        int domainSizeBefore = elements.getNbPresentElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (BitManager.isPresent(domainRepresentation, index)) {
                domain.removeElementAt(index);
            }
            index = elements.getNextPresent(index);
        }
        if (elements.getNbPresentElements() == 0) {
            ++this.nbWipeout;
            return false;
        }
        int nbRemovals = domainSizeBefore - elements.getNbPresentElements();
        if (nbRemovals > 0) {
            this.nbTotalRemovals += nbRemovals;
            this.set.updateAfterEffectiveRevisionOf(null, variable, nbRemovals);
        }
        return true;
    }

    public boolean checkWatchesOf(int variableId) {
        Variable variable = this.solver.getVariable(variableId);
        long[] currentDomainRepresentation = variable.getDomain().getElements().getBinaryRepresentation();
        WatchCell previous = null;
        WatchCell current = this.watches[variableId];
        while (current != null) {
            HyperNogood hyperNogood = current.hyperNogood;
            if (BitManager.isIncluded(currentDomainRepresentation, hyperNogood.getDomainRepresentationOfWatchedVariable(variableId))) {
                boolean found = this.canFindAnotherWatch(hyperNogood, hyperNogood.getWatchPositionOf(variableId));
                if (found) {
                    WatchCell tmp = current.nextCell;
                    if (previous == null) {
                        this.watches[variableId] = current.nextCell;
                    } else {
                        previous.nextCell = current.nextCell;
                    }
                    current.nextCell = this.free;
                    this.free = current;
                    current = tmp;
                    continue;
                }
                previous = current;
                current = current.nextCell;
                Variable inferredVariable = this.solver.getVariable(hyperNogood.getVariableIdOfWatchDifferentFrom(variableId));
                if (this.dealWithInference(inferredVariable, hyperNogood.getDomainRepresentationOfWatchedVariable(inferredVariable.getId()))) continue;
                return false;
            }
            previous = current;
            current = current.nextCell;
        }
        return true;
    }

    public void displayStats() {
        System.out.println(" nb NhyperNogoods = " + HyperNogood.nbGeneratedNogoods + " nb Total removals = " + this.nbTotalRemovals + " nb Wipeouts = " + this.nbWipeout);
    }

    public void display() {
        System.out.println("Nb Hyper Nogoods = " + this.nbHyperNogoods);
        int i = 0;
        while (i < this.watches.length) {
            System.out.print(" Watches for " + this.solver.getVariable(i) + " ");
            WatchCell cell = this.watches[i];
            while (cell != null) {
                System.out.println(cell.hyperNogood.toString());
                cell = cell.nextCell;
            }
            System.out.println();
            ++i;
        }
        System.out.println("fini");
    }

    class WatchCell {
        HyperNogood hyperNogood;
        WatchCell nextCell;

        WatchCell(HyperNogood hyperNogood, WatchCell nextCell) {
            this.hyperNogood = hyperNogood;
            this.nextCell = nextCell;
        }
    }
}

