/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.tools.BitManager;

public class HyperNogood {
    public static int nbGeneratedNogoods;
    int[] variableIndices;
    long[][] domainRepresentations;
    int[] watchedVariablePositions = new int[]{-1, -1};
    private int number;

    public int getNogoodId() {
        return this.number;
    }

    public boolean isWatched(int variableId) {
        return this.variableIndices[this.watchedVariablePositions[0]] == variableId || this.variableIndices[this.watchedVariablePositions[1]] == variableId;
    }

    public int getWatchPositionOf(int variableId) {
        assert (this.isWatched(variableId));
        return this.variableIndices[this.watchedVariablePositions[0]] == variableId ? 0 : 1;
    }

    public int getVariableIdOfWatchDifferentFrom(int variableId) {
        assert (this.isWatched(variableId));
        return this.variableIndices[this.watchedVariablePositions[0]] == variableId ? this.variableIndices[this.watchedVariablePositions[1]] : this.variableIndices[this.watchedVariablePositions[0]];
    }

    public long[] getDomainRepresentationOfWatchedVariable(int variableId) {
        assert (this.isWatched(variableId));
        int index = this.variableIndices[this.watchedVariablePositions[0]] == variableId ? this.watchedVariablePositions[0] : this.watchedVariablePositions[1];
        return this.domainRepresentations[index];
    }

    public long[] getDomainRepresentationOfVariableAtPosition(int position) {
        return this.domainRepresentations[position];
    }

    public HyperNogood(int[] variableIndices, long[][] domainRepresentations) {
        this.variableIndices = variableIndices;
        this.domainRepresentations = domainRepresentations;
        this.number = nbGeneratedNogoods++;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HyperNogood " + this.number + " of size " + this.variableIndices.length + " with watch1 = " + this.watchedVariablePositions[0] + " and watch2 = " + this.watchedVariablePositions[1] + "\n");
        int i = 0;
        while (i < this.variableIndices.length) {
            sb.append(String.valueOf(this.variableIndices[i]) + " : " + BitManager.decrypt(this.domainRepresentations[i]) + " \n");
            ++i;
        }
        return sb.toString();
    }
}

