/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.solvers.systematicSolvers.IterativeSystematicSolver;

public class ExtractionSolver
extends IterativeSystematicSolver {
    private static int nbRuns;
    private int nbActiveConstraints;
    private boolean[] activeConstraints;

    public int getNbRuns() {
        return nbRuns;
    }

    public int getNbActiveConstraints() {
        return this.nbActiveConstraints;
    }

    public boolean[] getActiveConstraints() {
        return this.activeConstraints;
    }

    private void setActiveConstraintsFromEffectiveRevisors(int nbEffectiveRevisors) {
        this.nbActiveConstraints = nbEffectiveRevisors;
        int i = 0;
        while (i < this.activeConstraints.length) {
            this.activeConstraints[i] = this.constraints[i].getNbEffectiveRevisions() > 0;
            ++i;
        }
    }

    public void setActiveConstraintsFromEffectiveRevisors() {
        this.nbActiveConstraints = this.computeNbConstraintsEffectiveRevisors();
        System.out.println("nb = " + this.nbActiveConstraints);
        this.activeConstraints = new boolean[this.constraints.length];
        int i = 0;
        while (i < this.activeConstraints.length) {
            this.activeConstraints[i] = this.constraints[i].getNbEffectiveRevisions() > 0;
            ++i;
        }
    }

    private int updateActiveConstraintsFromWeightedDegree() {
        int cpt = 0;
        int i = 0;
        while (i < this.activeConstraints.length) {
            if (this.constraints[i].getWeightedDegree() > 1L && !this.activeConstraints[i]) {
                this.activeConstraints[i] = true;
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void runNaiveApproach() {
        ++nbRuns;
        super.solve();
    }

    private void runProofApproach() {
        this.nbActiveConstraints = 0;
        this.activeConstraints = new boolean[this.constraints.length];
        boolean finished = false;
        while (!finished) {
            this.resolution.getCurrentInstanceStopwatch().start();
            ++nbRuns;
            this.reinitNbEffectiveRevisionsOfConstraints();
            super.solve();
            if (this.statistics.getNbFoundSolutions() > 0L) break;
            int nbEffectiveRevisors = this.computeNbConstraintsEffectiveRevisors();
            if (this.nbActiveConstraints == 0 || nbEffectiveRevisors < this.nbActiveConstraints) {
                this.setActiveConstraintsFromEffectiveRevisors(nbEffectiveRevisors);
            } else {
                finished = true;
            }
            System.out.println("    => nbEffectiveRevisors value = " + nbEffectiveRevisors + "\n");
        }
    }

    private void runConflictApproach() {
        int nbNewActiveConstraints;
        this.resolution.getCurrentInstanceStopwatch().start();
        ++nbRuns;
        super.solve();
        if (this.statistics.getNbFoundSolutions() > 0L) {
            return;
        }
        if (this.statistics.getNbPreproInconsistencies() > 0) {
            this.runProofApproach();
            return;
        }
        this.activeConstraints = new boolean[this.constraints.length];
        this.nbActiveConstraints = nbNewActiveConstraints = this.updateActiveConstraintsFromWeightedDegree();
        System.out.println("    => nbWRevisor value = " + this.nbActiveConstraints + "\n");
        int step = 3;
        while (nbNewActiveConstraints > 0 || step > 0) {
            this.resolution.getCurrentInstanceStopwatch().start();
            ++nbRuns;
            super.solve();
            nbNewActiveConstraints = this.updateActiveConstraintsFromWeightedDegree();
            this.nbActiveConstraints += nbNewActiveConstraints;
            step = nbNewActiveConstraints == 0 ? step - 1 : 3;
            System.out.println("    => nbWRevisor value = " + this.nbActiveConstraints + "\n");
        }
    }

    public boolean solve(boolean naive) {
        if (naive) {
            this.runNaiveApproach();
        } else {
            this.runProofApproach();
        }
        return this.getStatistics().getNbFoundSolutions() > 0L;
    }
}

