/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import java.util.Arrays;

public class DecisionManagerOld {
    private SystematicSolver solver;
    private int[] decisions;
    private int[] decisionsBackup;
    private int nbDecisions;
    private int[] offsets;

    public DecisionManagerOld(SystematicSolver solver) {
        this.solver = solver;
        int capacity = 0;
        this.offsets = new int[solver.getNbVariables()];
        int i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = capacity;
            capacity += solver.getVariable(i).getDomain().getMaximumSize();
            ++i;
        }
        this.decisions = new int[capacity];
    }

    public void addPositiveDecision(Variable variable, int index) {
        this.decisions[this.nbDecisions] = 1 + this.offsets[variable.getId()] + index;
        ++this.nbDecisions;
    }

    public void addNegativeDecision(Variable variable, int index) {
        this.decisions[this.nbDecisions] = (1 + this.offsets[variable.getId()] + index) * -1;
        ++this.nbDecisions;
    }

    public void replacePositiveByNegativeDecision(Variable variable, int index) {
        --this.nbDecisions;
        while (this.decisions[this.nbDecisions] < 0) {
            --this.nbDecisions;
        }
        assert (this.getVariableInDecision(this.decisions[this.nbDecisions]) == variable);
        this.decisions[this.nbDecisions] = (1 + this.offsets[variable.getId()] + index) * -1;
        ++this.nbDecisions;
    }

    public int[] getDecisionsToPerform(Variable pivot, Variable variable, int index) {
        int i;
        if (this.decisionsBackup == null) {
            this.decisionsBackup = new int[this.decisions.length + 1];
        }
        int start = 0;
        int cpt = 0;
        if (pivot != null) {
            start = this.getIndexOfPositiveDecisionWith(pivot);
            this.decisionsBackup[cpt++] = this.nbDecisions - start;
            this.decisionsBackup[cpt++] = this.decisions[start];
            i = start + 1;
            while (i < this.nbDecisions && this.decisions[i] < 0) {
                this.decisionsBackup[cpt++] = this.decisions[i];
                ++i;
            }
            this.decisionsBackup[cpt++] = (1 + this.offsets[variable.getId()] + index) * -1;
            i = start + cpt - 2;
            while (i < this.nbDecisions - 1) {
                this.decisionsBackup[cpt++] = this.decisions[i];
                ++i;
            }
        } else {
            this.decisionsBackup[cpt++] = this.nbDecisions;
            this.decisionsBackup[cpt++] = (1 + this.offsets[variable.getId()] + index) * -1;
            i = 0;
            while (i < this.nbDecisions - 1) {
                this.decisionsBackup[cpt++] = this.decisions[i];
                ++i;
            }
        }
        System.out.println(this.toString());
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.decisionsBackup[0]) + " decisions backup :");
        int i2 = 1;
        while (i2 <= this.decisionsBackup[0]) {
            sb.append(String.valueOf(this.getDecisionEncodedBy(this.decisionsBackup[i2])) + " ");
            ++i2;
        }
        System.out.println(sb.toString());
        this.nbDecisions = start;
        return this.decisionsBackup;
    }

    public int getIndexOfPositiveDecisionWith(Variable variable) {
        int i = 0;
        while (i < this.nbDecisions) {
            if (this.decisions[i] > 0 && this.getVariableInDecision(this.decisions[i]) == variable) {
                return i;
            }
            ++i;
        }
        throw new UnreachableCodeException();
    }

    public Variable getVariableInDecision(int codedDecision) {
        int p = Arrays.binarySearch(this.offsets, (codedDecision = Math.abs(codedDecision)) - 1);
        return this.solver.getVariable(p >= 0 ? p : -p - 2);
    }

    public int getIndexInDecision(int code, Variable variable) {
        return Math.abs(code) - 1 - this.offsets[variable.getId()];
    }

    public String getDecisionEncodedBy(int code) {
        assert (code != 0);
        boolean positive = code > 0;
        code = Math.abs(code);
        Variable variable = this.getVariableInDecision(code);
        int index = code - 1 - this.offsets[variable.getId()];
        return variable + (positive ? "=" : "!=") + index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.nbDecisions) + " decisions :");
        int i = 0;
        while (i < this.nbDecisions) {
            sb.append(String.valueOf(this.getDecisionEncodedBy(this.decisions[i])) + " ");
            ++i;
        }
        return sb.toString();
    }
}

