/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers.neighborHeuristics;

import abscon.problem.Variable;
import abscon.solvers.localSolvers.neighborHeuristics.NeighborHeuristic;

public class BestGlobal
extends NeighborHeuristic {
    private int tieSize;
    private int limitImprovement = 0;

    private void dealWith(Variable variable, boolean b) {
        if (variable == this.lastAssignedVariable) {
            return;
        }
        int potentialImprovement = this.solver.getConflictManager().getCurrentEvaluationOf(variable);
        if (this.bestEvolution < -potentialImprovement) {
            return;
        }
        if (potentialImprovement <= this.limitImprovement == b) {
            return;
        }
        int index = this.selectIndexOfBestNeighborOf(variable, this.bestEvolution);
        if (index < 0) {
            return;
        }
        assert (this.localBestEvolution <= this.bestEvolution);
        if (this.localBestEvolution < this.bestEvolution) {
            this.tieSize = 1;
            this.bestIndex = index;
            this.bestVariable = variable;
            this.bestEvolution = this.localBestEvolution;
        } else if (this.localBestEvolution == this.bestEvolution && this.counters[variable.getId()] < this.counters[this.bestVariable.getId()]) {
            this.bestIndex = index;
            this.bestVariable = variable;
        }
    }

    public void selectNeighbor() {
        int position;
        this.tieSize = 0;
        this.bestVariable = null;
        this.bestIndex = -1;
        this.bestEvolution = Integer.MAX_VALUE;
        Variable[] variables = this.solver.getVariables();
        int i = position = this.random.nextInt(variables.length);
        while (i < variables.length) {
            this.dealWith(variables[i], true);
            ++i;
        }
        i = 0;
        while (i < position) {
            this.dealWith(variables[i], true);
            ++i;
        }
        if (this.bestEvolution >= -this.limitImprovement) {
            i = position;
            while (i < variables.length) {
                this.dealWith(variables[i], false);
                ++i;
            }
            i = 0;
            while (i < position) {
                this.dealWith(variables[i], false);
                ++i;
            }
        }
        assert (this.bestVariable != null);
        assert (!this.tabuManager.isTabu(this.bestVariable, this.bestIndex) || this.bestEvolution == this.bestEvaluationEverSeen);
    }
}

