/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers;

import abscon.problem.Problem;
import abscon.solvers.Solver;
import abscon.solvers.Statistics;
import abscon.tools.Tools;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStatistics
extends Statistics {
    protected long nbInitialSearchConstraintChecks;
    protected long nbSearchConstraintChecks;
    protected long nbSearchValidityChecks;
    protected long nbSearchPropagations;
    protected long nbSearchRevisions;
    protected long nbSearchUselessRevisions;
    protected long nbConstraintChecks;
    protected long nbValidityChecks;
    protected long nbPropagations;
    protected long nbRevisions;
    protected long nbUselessRevisions;
    protected long nbAssignments;
    protected long nbFailedAssignments;
    protected long nbBacktracks;

    public LocalStatistics(Solver solver) {
        super(solver);
    }

    @Override
    public long getNbAssignments() {
        return this.nbAssignments;
    }

    public long getNbFailedAssignments() {
        return this.nbFailedAssignments;
    }

    public void resetNbFailedAssignments() {
        this.nbFailedAssignments = 0L;
    }

    public long getNbBacktracks() {
        return this.nbBacktracks;
    }

    public void incrementNbAssignments() {
        ++this.nbAssignments;
    }

    public void decrementNbAssignments() {
        --this.nbAssignments;
    }

    public void incrementNbFailedAssignments() {
        ++this.nbFailedAssignments;
    }

    public void incrementNbBacktracks() {
        ++this.nbBacktracks;
    }

    @Override
    public long getNbConstraintChecks() {
        return this.nbPreproConstraintChecks + this.nbSearchConstraintChecks;
    }

    @Override
    public long getNbValidityChecks() {
        return this.nbPreproValidityChecks + this.nbSearchValidityChecks;
    }

    @Override
    public long getNbPropagations() {
        return this.nbPreproPropagations + this.nbSearchPropagations;
    }

    @Override
    public long getNbRevisions() {
        return this.nbPreproRevisions + this.nbSearchRevisions;
    }

    @Override
    public long getNbUselessRevisions() {
        return this.nbPreproUselessRevisions + this.nbSearchUselessRevisions;
    }

    public void setInitialSearchConstraintChecks(long l) {
        this.nbInitialSearchConstraintChecks = l;
    }

    @Override
    protected void manageAfterPreprocessing(boolean preproConsistency) {
        super.manageAfterPreprocessing(preproConsistency);
        this.nbAssignments = 0L;
    }

    @Override
    protected void manageAfterSearch() {
        Problem problem = this.solver.getProblem();
        this.searchCpuTime = this.stopwatch.getCurrentCpuTime();
        this.searchWckTime = this.stopwatch.getCurrentWallClockTime();
        this.nbSearchConstraintChecks += problem.getNbConstraintChecks();
        this.nbSearchValidityChecks += problem.getNbValidityChecks();
        this.nbConstraintChecks += this.nbPreproConstraintChecks + this.nbSearchConstraintChecks;
        this.nbValidityChecks += this.nbPreproValidityChecks + this.nbSearchValidityChecks;
        this.nbPropagations += this.nbPreproPropagations + this.nbSearchPropagations;
        this.nbRevisions += this.nbPreproRevisions + this.nbSearchRevisions;
        this.nbUselessRevisions += this.nbPreproUselessRevisions + this.nbSearchUselessRevisions;
    }

    @Override
    public Map<String, String> getMapOfSearchAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int run = this.solver.getRestarter().getCurrentRun();
        map.put("run", run == -1 ? "all" : String.valueOf(run));
        map.put("nbConstraintChecks", String.valueOf(this.nbSearchConstraintChecks));
        if (this.nbInitialSearchConstraintChecks != 0L) {
            map.put("nbBeforeConstraintsChecks", String.valueOf(this.nbInitialSearchConstraintChecks));
        }
        map.put("nbAssignments", String.valueOf(this.nbAssignments));
        map.put("wckTime", String.valueOf((double)this.searchWckTime / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.searchCpuTime / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    @Override
    public Map<String, String> getMapOfCumulatedAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nbConstraintChecks", String.valueOf(this.getNbConstraintChecks()));
        map.put("nbValidityChecks", String.valueOf(this.getNbValidityChecks()));
        map.put("nbPropagations", String.valueOf(this.getNbPropagations()));
        map.put("nbRevisions", String.valueOf(this.getNbRevisions()));
        map.put("nbUselessRevisions", String.valueOf(this.getNbUselessRevisions()));
        return map;
    }
}

