/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.solvers.localSolvers.LocalSearchSolver;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.Arrays;

public class ConflictManager {
    private LocalSearchSolver localSolver;
    private Constraint[] constraints;
    private int size;
    private int[] positionOfElements;
    private int[] currentVariableEvaluations;
    private int currentEvaluation;
    private boolean weighting;

    public int getCurrentEvaluation() {
        return this.currentEvaluation;
    }

    public int getCurrentEvaluationOf(Variable variable) {
        return this.currentVariableEvaluations[variable.getId()];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.positionOfElements, -1);
        Arrays.fill(this.currentVariableEvaluations, 0);
        this.size = 0;
    }

    public ConflictManager(LocalSearchSolver localSolver) {
        this.localSolver = localSolver;
        int capacity = localSolver.getProblem().getNbConstraints();
        this.positionOfElements = new int[capacity];
        this.constraints = new Constraint[capacity];
        this.currentVariableEvaluations = new int[localSolver.getProblem().getNbVariables()];
        this.clear();
        this.weighting = ConfigurationManager.getBoolean(localSolver.getLevelInResolution(), "search/assignmentHeuristic", "weighting");
    }

    public void add(Constraint constraint) {
        if (this.positionOfElements[constraint.getId()] != -1) {
            return;
        }
        this.positionOfElements[constraint.getId()] = this.size;
        this.constraints[this.size] = constraint;
        ++this.size;
    }

    public void remove(Constraint constraint) {
        int position = this.positionOfElements[constraint.getId()];
        if (position == -1) {
            return;
        }
        if (position != this.size - 1) {
            Constraint lastConstraint;
            this.constraints[position] = lastConstraint = this.constraints[this.size - 1];
            this.positionOfElements[lastConstraint.getId()] = position;
        }
        this.positionOfElements[constraint.getId()] = -1;
        --this.size;
    }

    public void updateFromNewAssignmentOf(Variable variable) {
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!constraint.checkCurrent()) {
                this.add(constraint);
            } else {
                this.remove(constraint);
            }
            ++n;
        }
        this.updateEvaluations();
    }

    public void updateEvaluations() {
        this.currentEvaluation = 0;
        Arrays.fill(this.currentVariableEvaluations, 0);
        int i = 0;
        while (i < this.size) {
            if (this.weighting) {
                this.constraints[i].incrementWeigthedDegree();
            }
            this.currentEvaluation = (int)((long)this.currentEvaluation + this.constraints[i].getWeightedDegree());
            Variable[] variableArray = this.constraints[i].getInvolvedVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                int n3 = variable.getId();
                this.currentVariableEvaluations[n3] = (int)((long)this.currentVariableEvaluations[n3] + this.constraints[i].getWeightedDegree());
                ++n;
            }
            ++i;
        }
    }

    public int computeEvaluationOf(Variable variable) {
        int evaluation = 0;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!constraint.checkCurrent()) {
                evaluation = (int)((long)evaluation + constraint.getWeightedDegree());
            }
            ++n;
        }
        return evaluation;
    }

    public int computeEvaluationOf(Variable variable, int index) {
        int currentIndex = variable.getDomain().getUniqueIndex();
        variable.getDomain().setUniqueIndex(index);
        int evaluation = this.computeEvaluationOf(variable);
        variable.getDomain().setUniqueIndex(currentIndex);
        return evaluation;
    }

    public int computeEvolutionOf(Variable variable, int index) {
        return this.computeEvaluationOf(variable, index) - this.getCurrentEvaluationOf(variable);
    }

    public int computeEvolutionOfUpto(Variable variable, int index, int limit) {
        int currentIndex = variable.getDomain().getUniqueIndex();
        variable.getDomain().setUniqueIndex(index);
        int evaluation = -this.getCurrentEvaluationOf(variable);
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!constraint.checkCurrent()) {
                evaluation = (int)((long)evaluation + constraint.getWeightedDegree());
            }
            if (evaluation > limit) break;
            ++n;
        }
        variable.getDomain().setUniqueIndex(currentIndex);
        return evaluation;
    }
}

