/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers;

import abscon.Resolution;
import abscon.constraints.Constraint;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency3Single;
import abscon.solvers.Solver;
import abscon.tools.Stopwatch;
import abscon.tools.Tools;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statistics {
    protected Solver solver;
    protected Stopwatch stopwatch = new Stopwatch();
    protected Stopwatch globalStopwatch = new Stopwatch();
    protected long nbPreproConstraintChecks;
    protected long nbPreproValidityChecks;
    protected long nbPreproPropagations;
    protected long nbPreproRevisions;
    protected long nbPreproUselessRevisions;
    protected long nbPreproRemovals;
    protected long nbPreproTuplesRemovals;
    protected long nbPreproValidSupports;
    protected int nbPreproInconsistencies;
    protected long nbPreproSingletonTests;
    protected long nbPreproEffectiveSingletonTests;
    protected long durationToBuildProblem;
    protected long durationToBuildSolver;
    protected long preproWckTime;
    protected long preproCpuTime;
    protected long searchWckTime;
    protected long searchCpuTime;
    protected long firstSolutionWckTime;
    protected long firstSolutionCpuTime;
    protected long buildingCpuTime;
    protected long buildingWckTime;
    protected long solvingCpuTime;
    protected long solvingWckTime;
    protected long nbFoundSolutions;
    protected double substitutabilityRatio;

    public Statistics(Solver s) {
        this.solver = s;
    }

    public long getNbAssignments() {
        return 0L;
    }

    public long getPreproWallClockTime() {
        return this.preproWckTime;
    }

    public long getSearchWallClockTime() {
        return this.searchWckTime;
    }

    public long getDurationToRunSolver() {
        return this.solvingWckTime;
    }

    public long getNbConstraintChecks() {
        return this.nbPreproConstraintChecks;
    }

    public long getNbPreproSingletonTests() {
        return this.nbPreproSingletonTests;
    }

    public long getNbPreproEffectiveSingletonTests() {
        return this.nbPreproEffectiveSingletonTests;
    }

    public long getNbValidityChecks() {
        return this.nbPreproValidityChecks;
    }

    public long getNbPropagations() {
        return this.nbPreproPropagations;
    }

    public long getNbRevisions() {
        return this.nbPreproRevisions;
    }

    public long getNbUselessRevisions() {
        return this.nbPreproUselessRevisions;
    }

    public int computeNbRemovals() {
        int cpt = 0;
        Variable[] variableArray = this.solver.getProblem().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            cpt += variable.getDomain().getNbLostElements();
            ++n;
        }
        return cpt;
    }

    public int computeNbTuplesRemovals() {
        int cpt = 0;
        Constraint[] constraintArray = this.solver.getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint instanceof ExtensionConstraint) {
                cpt += ((ExtensionConstraint)constraint).getExtensionStructure().getNbTuplesRemoved();
            }
            ++n;
        }
        return cpt;
    }

    public long getNbPreproRemovals() {
        return this.nbPreproRemovals;
    }

    public long getNbPreproTuplesRemovals() {
        return this.nbPreproTuplesRemovals;
    }

    public long getNbPreproValidSupports() {
        return this.nbPreproValidSupports;
    }

    public int getNbPreproInconsistencies() {
        return this.nbPreproInconsistencies;
    }

    public long getNbFoundSolutions() {
        return this.nbFoundSolutions;
    }

    public void incrementNbFoundSolutionsOf(int increment) {
        this.nbFoundSolutions += (long)increment;
    }

    protected void manageBeforeSolve() {
        this.durationToBuildProblem = this.solver.getProblem().getDurationToBeBuilt();
        this.durationToBuildSolver = this.solver.getDurationToBeBuilt();
        this.globalStopwatch.start();
    }

    void manageBeforePreprocessing() {
        this.solver.getProblem().resetCounters();
        this.solver.getPreproPropagationTechnique().resetCounters();
        this.stopwatch.start();
    }

    protected void manageAfterPreprocessing(boolean preproConsistency) {
        Problem problem = this.solver.getProblem();
        this.preproCpuTime += this.stopwatch.getCurrentCpuTime();
        this.preproWckTime += this.stopwatch.getCurrentWallClockTime();
        this.nbPreproConstraintChecks += problem.getNbConstraintChecks();
        this.nbPreproValidityChecks += problem.getNbValidityChecks();
        this.nbPreproPropagations += this.solver.getPreproPropagationTechnique().getNbPropagations();
        this.nbPreproRevisions += this.solver.getPreproPropagationTechnique().getNbRevisions();
        this.nbPreproUselessRevisions += this.solver.getPreproPropagationTechnique().getNbUselessRevisions();
        this.nbPreproRemovals += (long)this.computeNbRemovals();
        this.nbPreproTuplesRemovals += (long)this.computeNbTuplesRemovals();
        this.nbPreproValidSupports = preproConsistency && this.nbPreproTuplesRemovals > 0L ? this.solver.getProblem().countNbValidSupports() : 0;
        this.nbPreproInconsistencies += preproConsistency ? 0 : 1;
        if (this.solver.getPreproPropagationTechnique() instanceof SingletonArcConsistency) {
            this.nbPreproSingletonTests = ((SingletonArcConsistency)this.solver.getPreproPropagationTechnique()).getNbSingletonTests();
            this.nbPreproEffectiveSingletonTests = ((SingletonArcConsistency)this.solver.getPreproPropagationTechnique()).getNbEffectiveSingletonTests();
        }
    }

    protected void manageBeforeSearch() {
        this.solver.getProblem().resetCounters();
    }

    protected void manageAfterSearch() {
    }

    protected void manageAfterSolve() {
        this.buildingCpuTime += this.solver.getResolution().getBuildingStopwatch().getStoppedCpuTime();
        this.buildingWckTime += this.solver.getResolution().getBuildingStopwatch().getStoppedWallClockTime();
        this.solvingCpuTime += this.globalStopwatch.getCurrentCpuTime();
        this.solvingWckTime += this.globalStopwatch.getCurrentWallClockTime();
    }

    void manageSolution() {
        ++this.nbFoundSolutions;
        if (this.nbFoundSolutions == 1L) {
            this.firstSolutionCpuTime += this.globalStopwatch.getCurrentCpuTime();
            this.firstSolutionWckTime = this.globalStopwatch.getCurrentWallClockTime();
        }
    }

    public Map<String, String> getMapOfPreproAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nbConstraintChecks", String.valueOf(this.nbPreproConstraintChecks));
        if (this.nbPreproValidityChecks > 0L) {
            map.put("nbValidityChecks", String.valueOf(this.nbPreproValidityChecks));
        }
        map.put("nbPropagations", String.valueOf(this.nbPreproPropagations));
        map.put("nbRevisions", String.valueOf(this.nbPreproRevisions));
        map.put("nbUselessRevisions", String.valueOf(this.nbPreproUselessRevisions));
        if (this.nbPreproSingletonTests > 0L) {
            map.put("nbSingletonTests", String.valueOf(this.nbPreproSingletonTests));
            map.put("nbEffectiveSingletonTests", String.valueOf(this.nbPreproEffectiveSingletonTests));
            if (this.solver.getPreproPropagationTechnique() instanceof SingletonArcConsistency3Single) {
                map.put("nbESACBranches", String.valueOf(((SingletonArcConsistency3Single)this.solver.getPreproPropagationTechnique()).getNbBuiltBranches()));
            }
        }
        map.put("nbRemovedValues", String.valueOf(this.nbPreproRemovals));
        if (this.nbPreproTuplesRemovals > 0L) {
            map.put("nbRemovedTuples", String.valueOf(this.nbPreproTuplesRemovals));
            map.put("nbValidSupports", String.valueOf(this.nbPreproValidSupports));
        }
        map.put("detectedInconsistency", this.nbPreproInconsistencies > 0 ? "yes" : "no");
        map.put("wckTime", String.valueOf((double)this.preproWckTime / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.preproCpuTime / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    public abstract Map<String, String> getMapOfSearchAttributes();

    public abstract Map<String, String> getMapOfCumulatedAttributes();

    public Map<String, String> getMapOfGlobalAttributes() {
        Map<String, String> map = this.getMapOfCumulatedAttributes();
        map.put("solvingWckTime", String.valueOf((double)this.solvingWckTime / 1000.0));
        map.put("solvingCpuTime", String.valueOf((double)this.solvingCpuTime / 1000.0));
        map.put("expiredTime", this.solver.getResolution().isTimeExpired() ? "yes" : "no");
        map.put("totalExploration", this.solver.getFullExploration() ? "yes" : "no");
        map.put("nbFoundSolutions", String.valueOf(this.nbFoundSolutions));
        if (this.solver.getResolution().getRecordSolutions()) {
            map.put("nbUniqueSolutions", String.valueOf(this.solver.getNbUniqueSolutions()));
        }
        map.put("globalCpuTime", String.valueOf((double)Resolution.getResolutionStopwatch().getCurrentCpuTime() / 1000.0));
        map.put("wckTime", String.valueOf((double)this.solver.getResolution().getCurrentInstanceStopwatch().getCurrentWallClockTime() / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.solver.getResolution().getCurrentInstanceStopwatch().getCurrentCpuTime() / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }
}

