/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers;

import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import java.util.Arrays;

public class GraphManager {
    private SystematicSolver solver;
    private int[] componentNumber;
    private Variable[] bestComponent;
    private int bestComponentSize;
    private int bestComponentNumber;
    private int nbComponents;
    private int[] nodeOrdering;
    private boolean[] articulations;
    private int currentOrdering;
    private int nbCycles;
    private Variable articulationPoint;

    public int getNbComponents() {
        return this.nbComponents;
    }

    public Variable[] getBestComponent() {
        return this.bestComponent;
    }

    public int getBestComponentSize() {
        return this.bestComponentSize;
    }

    public GraphManager(SystematicSolver solver) {
        this.solver = solver;
        this.componentNumber = new int[solver.getNbVariables()];
        this.nodeOrdering = new int[solver.getNbVariables()];
        this.articulations = new boolean[solver.getNbVariables()];
        this.bestComponent = new Variable[solver.getNbVariables()];
    }

    private int determineConnexComponentOf(Variable variable, int currentComponentNumber) {
        int cpt = 1;
        boolean tree = true;
        this.componentNumber[variable.getId()] = currentComponentNumber;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (neighbour.isFuture()) {
                    if (this.componentNumber[neighbour.getId()] == -1) {
                        int result = this.determineConnexComponentOf(neighbour, currentComponentNumber);
                        if (result > 0) {
                            tree = false;
                        }
                        cpt += Math.abs(result);
                    } else {
                        tree = false;
                    }
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var)) {
                    if (this.componentNumber[var.getId()] == -1) {
                        int result = this.determineConnexComponentOf(var, currentComponentNumber);
                        if (result > 0) {
                            tree = false;
                        }
                        cpt += Math.abs(result);
                    } else {
                        tree = false;
                    }
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
        return tree ? -cpt : cpt;
    }

    private boolean controlConnexComponents(Variable[] variables, int leftFrontier, int rightFrontier) {
        int i = 0;
        while (i < this.componentNumber.length) {
            if (this.componentNumber[i] != -1) {
                boolean found = false;
                int j = leftFrontier;
                while (!found && j <= rightFrontier) {
                    if (variables[j].getId() == i) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void determineConnexComponentsIn(Variable[] variables, int leftFrontier, int rightFrontier) {
        this.nbComponents = 0;
        if (rightFrontier < leftFrontier) {
            return;
        }
        this.bestComponentNumber = -1;
        this.bestComponentSize = this.solver.getNbVariables() + 1;
        int bestTreeNumber = -1;
        int bestTreeSize = this.solver.getNbVariables() + 1;
        Arrays.fill(this.componentNumber, -1);
        int i = leftFrontier;
        while (i <= rightFrontier) {
            if (variables[i].isFuture() && this.componentNumber[variables[i].getId()] == -1) {
                int componentSize = this.determineConnexComponentOf(variables[i], this.nbComponents);
                assert (componentSize != 0);
                if (componentSize < 0 && Math.abs(componentSize) < bestTreeSize) {
                    bestTreeSize = Math.abs(componentSize);
                    bestTreeNumber = this.nbComponents;
                }
                if (componentSize > 0 && componentSize < this.bestComponentSize) {
                    this.bestComponentSize = componentSize;
                    this.bestComponentNumber = this.nbComponents;
                }
                ++this.nbComponents;
            }
            ++i;
        }
        if (this.bestComponentNumber == -1) {
            this.bestComponentSize = bestTreeSize;
            this.bestComponentNumber = bestTreeNumber;
        }
        assert (this.controlConnexComponents(variables, leftFrontier, rightFrontier));
        int cpt = 0;
        int i2 = leftFrontier;
        while (i2 <= rightFrontier) {
            if (this.componentNumber[variables[i2].getId()] == this.bestComponentNumber) {
                this.bestComponent[cpt++] = variables[i2];
            }
            ++i2;
        }
        assert (this.nbComponents == 0 || cpt == this.bestComponentSize) : "cpt =" + cpt + " best = " + this.bestComponentSize + "nbC = " + this.nbComponents;
        this.displayConnexComponents(variables, leftFrontier, rightFrontier);
    }

    public void determineConnexComponents() {
        Variable[] variables = new Variable[this.solver.getVariableManager().getNbFutureVariables()];
        int cpt = 0;
        Variable fv = this.solver.getFirstFutureVariable();
        while (fv != null) {
            variables[cpt++] = fv;
            fv = this.solver.getNextFutureVariableAfter(fv);
        }
        this.determineConnexComponentsIn(variables, 0, variables.length - 1);
    }

    private void displayConnexComponents(Variable[] variables, int leftFrontier, int rightFrontier) {
        int i = 0;
        while (i < this.nbComponents) {
            int cpt = 0;
            System.out.print("Component " + i + " = { ");
            Variable var = null;
            int j = leftFrontier;
            while (j <= rightFrontier) {
                if (this.componentNumber[variables[j].getId()] == i) {
                    var = variables[j];
                    if (++cpt < 10) {
                        System.out.print(variables[j] + " ");
                    }
                }
                ++j;
            }
            System.out.println(String.valueOf(cpt >= 10 ? "..." : "") + "} with " + cpt + " elements" + (cpt == 1 ? " ddegrre = " + var.getDynamicDegree() : ""));
            ++i;
        }
    }

    private int searchAttachment(Variable parent, Variable variable, Variable forbiddenVariable) {
        this.nodeOrdering[variable.getId()] = ++this.currentOrdering;
        int min = this.currentOrdering;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (neighbour.isFuture() && neighbour != forbiddenVariable) {
                    if (this.nodeOrdering[neighbour.getId()] == -1) {
                        int attachment = this.searchAttachment(variable, neighbour, forbiddenVariable);
                        min = Math.min(min, attachment);
                        if (attachment >= this.nodeOrdering[variable.getId()]) {
                            this.articulations[variable.getId()] = true;
                            this.articulationPoint = variable;
                        }
                    } else if (this.nodeOrdering[neighbour.getId()] < this.nodeOrdering[variable.getId()] && neighbour != parent) {
                        min = Math.min(min, this.nodeOrdering[neighbour.getId()]);
                        ++this.nbCycles;
                    }
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var) && var != forbiddenVariable) {
                    if (this.nodeOrdering[var.getId()] == -1) {
                        int attachment = this.searchAttachment(variable, var, forbiddenVariable);
                        min = Math.min(min, attachment);
                        if (attachment >= this.nodeOrdering[variable.getId()]) {
                            this.articulations[variable.getId()] = true;
                            this.articulationPoint = variable;
                        }
                    } else if (this.nodeOrdering[var.getId()] < this.nodeOrdering[variable.getId()] && var != parent) {
                        min = Math.min(min, this.nodeOrdering[var.getId()]);
                        ++this.nbCycles;
                    }
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
        return min;
    }

    private Variable searchArticulationsFrom(Variable variable, Variable forbiddenVariable, boolean allowedTreeArticulation) {
        assert (variable != forbiddenVariable);
        this.nodeOrdering[variable.getId()] = ++this.currentOrdering;
        this.nbCycles = 0;
        this.articulationPoint = null;
        int nbConnexComponentsIfAssigned = 0;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (neighbour.isFuture() && neighbour != forbiddenVariable && this.nodeOrdering[neighbour.getId()] == -1) {
                    this.searchAttachment(variable, neighbour, forbiddenVariable);
                    ++nbConnexComponentsIfAssigned;
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var) && var != forbiddenVariable && this.nodeOrdering[var.getId()] == -1) {
                    this.searchAttachment(variable, var, forbiddenVariable);
                    ++nbConnexComponentsIfAssigned;
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
        if (nbConnexComponentsIfAssigned > 1) {
            this.articulations[variable.getId()] = true;
            this.articulationPoint = variable;
        }
        return !allowedTreeArticulation && this.nbCycles == 0 ? null : this.articulationPoint;
    }

    public void displayArticulations() {
        boolean found = false;
        int i = 0;
        while (i < this.articulations.length) {
            if (this.articulations[i]) {
                System.out.print(String.valueOf(!found ? "Articulation " : "") + i + " ");
                found = true;
            }
            ++i;
        }
        if (found) {
            System.out.println();
        }
    }

    public Variable findFirstArticulation(Variable forbiddenVariable, boolean allowedTreeArticulation) {
        this.currentOrdering = -1;
        Arrays.fill(this.nodeOrdering, -1);
        Arrays.fill(this.articulations, false);
        Variable futureVariable = this.solver.getFirstFutureVariable();
        while (futureVariable != null) {
            Variable articulation;
            if (futureVariable != forbiddenVariable && this.nodeOrdering[futureVariable.getId()] == -1 && (articulation = this.searchArticulationsFrom(futureVariable, forbiddenVariable, allowedTreeArticulation)) != null) {
                System.out.println("Articulation " + articulation + " allowed = " + allowedTreeArticulation);
                return articulation;
            }
            futureVariable = this.solver.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }

    public Variable findFirstArticulation(boolean allowedTreeArticulation) {
        return this.findFirstArticulation(null, allowedTreeArticulation);
    }

    public Variable findFirstVariableInArticulationPair() {
        Variable futureVariable = this.solver.getFirstFutureVariable();
        while (futureVariable != null) {
            Variable variable = this.findFirstArticulation(futureVariable, true);
            if (variable != null) {
                return variable;
            }
            futureVariable = this.solver.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }
}

