/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.MaxRPC;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitb;
import abscon.tools.elements.Elements;
import abscon.tools.math.LexicographicComparator;

public abstract class SupportUnitOptimal
extends SupportUnit {
    public static final int UNINITIALIZED = -1;
    protected SupportManagerOptimal supportManager;
    protected int[][] lastSupports;
    protected int[][] lastStackSupports;
    protected int[] lastDepths;
    protected int nbEffectiveRestorations;
    protected int globalDepth;
    protected int[] buffer;

    public int getNbEffectiveRestorations() {
        return this.nbEffectiveRestorations;
    }

    public boolean isInitialized(int index) {
        return this.lastSupports[index][this.brotherPosition] != -1;
    }

    public int[] getLastSupportOf(int index) {
        return this.lastSupports[index];
    }

    public int getLastSupportFromBrotherOf(int index) {
        return this.lastSupports[index][this.brotherPosition];
    }

    public int getGlobalDepth() {
        return this.globalDepth;
    }

    protected void updateDepths(int index, int depth) {
        this.lastDepths[index] = depth;
        this.globalDepth = depth;
        this.supportManager.setLastDepth(this.constraint.getId(), depth);
        assert (this.controlDepths() && this.supportManager.controlModificationDepths(this.constraint.getId()));
    }

    public SupportUnitOptimal(SupportManagerOptimal supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        this.supportManager = supportManager;
        this.lastDepths = new int[variable.getDomain().getMaximumSize()];
        this.buffer = new int[constraint.getNbInvolvedVariables()];
        if (!(this instanceof SupportUnitb)) {
            this.lastSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
            this.lastStackSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
        }
    }

    public void initialize() {
        int i = 0;
        while (i < this.lastSupports.length) {
            this.lastSupports[i][this.variablePosition] = i;
            this.lastSupports[i][this.brotherPosition] = -1;
            this.lastStackSupports[i][this.variablePosition] = i;
            this.lastStackSupports[i][this.brotherPosition] = -1;
            ++i;
        }
        this.globalDepth = 0;
    }

    protected void copySupport(int[] dstSupport, int[] srcSupport) {
        int i = 0;
        while (i < dstSupport.length) {
            dstSupport[i] = srcSupport[i];
            ++i;
        }
    }

    protected boolean restore(int index, int depthLimit) {
        if (this.lastDepths[index] <= depthLimit && !this.supportManager.isSolverUsingDynamicBacktracking()) {
            return false;
        }
        ++this.nbEffectiveRestorations;
        this.copySupport(this.lastSupports[index], this.lastStackSupports[index]);
        this.lastDepths[index] = 0;
        return true;
    }

    public void restore(int depthLimit) {
        if (this.globalDepth > depthLimit || this.supportManager.isSolverUsingDynamicBacktracking()) {
            Elements elements = this.variable.getDomain().getElements();
            int index = elements.getFirstPresent();
            while (index != -1) {
                this.restore(index, depthLimit);
                index = elements.getNextPresent(index);
            }
            this.globalDepth = depthLimit;
            assert (this.controlDepths());
        } else assert (this.controlDepths()) : String.valueOf(depthLimit) + " ";
    }

    protected void manageNewSupport(int index) {
        this.copySupport(this.lastSupports[index], this.buffer);
        int depth = this.supportManager.getPropagationTechnique().getSolver().getCurrentDepth();
        this.updateDepths(index, depth);
        if (depth == 0) {
            this.copySupport(this.lastStackSupports[index], this.buffer);
        }
    }

    public boolean getArcSupportOf(int index) {
        assert (!this.variable.isAssigned()) : "variable " + this.variable + " is assigned";
        assert (this.variable.getDomain().hasIndex(index)) : "variable " + this.variable + " has not " + index;
        boolean success = false;
        int[] support = this.lastSupports[index];
        if (support[this.brotherPosition] == -1) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            assert (this.supportManager.getPropagationTechnique() instanceof MaxRPC || this.controlCoherenceOfLastSupportWrt(index));
            if (this.constraint.checkValidityOf(support)) {
                return true;
            }
            this.copySupport(this.buffer, support);
            success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        if (success) {
            this.manageNewSupport(index);
        }
        return success;
    }

    public boolean getPathSupportOf(int index) {
        throw new MissingImplementationException();
    }

    public void display() {
        super.display();
        System.out.println("   gmd =" + this.globalDepth);
        System.out.print("   values = {");
        int i = 0;
        while (i < this.lastDepths.length) {
            System.out.print(String.valueOf(i) + (!this.variable.getDomain().hasIndex(i) ? "x" : "") + ":lmd");
            System.out.print(String.valueOf(this.lastDepths[i]) + (i < this.lastDepths.length - 1 ? " ," : ""));
            ++i;
        }
        System.out.println("}");
        System.out.println(" **LastInternSupports of (" + this.constraint + "," + this.variable + ")");
        i = 0;
        while (i < this.lastDepths.length) {
            System.out.print("   " + i + (!this.variable.getDomain().hasIndex(i) ? "x" : "") + "=>(");
            int[] support = this.getLastSupportOf(i);
            if (support[this.brotherPosition] == -1) {
                System.out.print("!init");
            } else {
                int j = 0;
                while (j < support.length) {
                    System.out.print(support[j]);
                    if (j < support.length - 1) {
                        System.out.print(",");
                    }
                    ++j;
                }
            }
            System.out.print(")");
            if (i < this.lastDepths.length - 1) {
                System.out.print(" ;");
            }
            ++i;
        }
        System.out.println();
    }

    public boolean control() {
        return true;
    }

    protected boolean controlDepths() {
        boolean coherent;
        int max = 0;
        int i = 0;
        while (i < this.lastDepths.length) {
            if (this.isInitialized(i) && this.variable.getDomain().hasIndex(i)) {
                max = Math.max(max, this.lastDepths[i]);
            }
            ++i;
        }
        boolean bl = coherent = max <= this.globalDepth && max <= this.supportManager.getLastDepth(this.constraint.getId());
        if (!coherent) {
            System.out.println("Max =  " + max + " global =  " + this.globalDepth + " supportManagerDepth = " + this.supportManager.getLastDepth(this.constraint.getId()));
            this.display();
        }
        return coherent;
    }

    protected boolean controlCoherenceOfLastSupportWrt(int index) {
        boolean coherent;
        int[] support = this.getLastSupportOf(index);
        assert (support[this.brotherPosition] != -1);
        boolean success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        if (!success) {
            return true;
        }
        LexicographicComparator lc = new LexicographicComparator();
        boolean bl = coherent = lc.compare(support, this.buffer) <= 0;
        if (!coherent) {
            System.out.println("Support Unit of " + this.constraint + " " + this.variable + " with incohent index " + index);
            this.display();
            System.out.print("Found the support ");
            int i = 0;
            while (i < this.buffer.length) {
                System.out.print(" " + this.buffer[i]);
                ++i;
            }
            System.out.println();
        }
        return coherent;
    }
}

