/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.solvers.Solver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public final class SupportUnit2005bN
extends SupportUnit {
    private SupportUnit2005bN brotherUnit;
    private int[] lastFoundSupports;
    protected int[] lastStackSupports;
    private Elements brotherElements;
    protected int[] buffer;
    private int variant;
    private Solver solver;

    public SupportUnit2005bN(SupportManager supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        if (constraint.getArity() != 2) {
            throw new IncompatiblePropertiesException();
        }
        if (supportManager.mustStackSupports()) {
            throw new IncompatiblePropertiesException();
        }
        if (supportManager.isCandidateAttentive()) {
            throw new IncompatiblePropertiesException();
        }
        this.lastFoundSupports = new int[variable.getDomain().getMaximumSize()];
        this.lastStackSupports = new int[variable.getDomain().getMaximumSize()];
        this.brotherElements = constraint.getInvolvedVariable(this.brotherPosition).getDomain().getElements();
        this.buffer = new int[2];
        this.variant = ConfigurationManager.getInt(supportManager.getPropagationTechnique().getLevel(), String.valueOf(supportManager.getPropagationTechnique().getPhase()) + "/" + "propagationTechnique" + "/" + "supportManager", "variant");
        this.solver = supportManager.getPropagationTechnique().getSolver();
    }

    public void initialize() {
        if (this.brotherUnit == null) {
            Arrays.fill(this.lastFoundSupports, -1);
            Arrays.fill(this.lastStackSupports, -1);
            this.brotherUnit = (SupportUnit2005bN)this.supportManager.getSupportUnitOf(this.constraint, this.constraint.getInvolvedVariable(this.brotherPosition));
        }
    }

    public void restore(int index) {
    }

    protected final void manageNewSupport(int index) {
        int value = this.buffer[this.brotherPosition];
        if (this.solver.getCurrentDepth() == 0) {
            this.lastStackSupports[index] = value;
        }
        this.lastFoundSupports[index] = value;
        if (this.variant == 0) {
            this.brotherUnit.lastFoundSupports[value] = index;
        }
    }

    public boolean getArcSupportOf(int index) {
        boolean success;
        int lastFoundSupport = this.lastFoundSupports[index];
        if (lastFoundSupport != -1) {
            this.constraint.getProblem().incrementNbValidityChecks();
            if (this.brotherElements.isPresent(lastFoundSupport)) {
                return true;
            }
        }
        int lastStackSupport = this.lastStackSupports[index];
        if (this.brotherElements.getFirstPresent() > lastStackSupport) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            this.constraint.getProblem().incrementNbValidityChecks();
            if (this.brotherElements.isPresent(lastStackSupport)) {
                return true;
            }
            this.buffer[this.variablePosition] = index;
            this.buffer[this.brotherPosition] = lastStackSupport;
            success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        if (success) {
            this.manageNewSupport(index);
        }
        return success;
    }

    public boolean getPathSupportOf(int index) {
        throw new UnreachableCodeException();
    }
}

