/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Bits;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2005;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2005N;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2005b;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2005bN;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitUnaryConstraint;
import abscon.tools.absconParameters.ConfigurationManager;

public class SupportManagerRm
extends SupportManager {
    private boolean recordFirst = false;

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        this.candidateAttentive = false;
        this.stackSupports = false;
        boolean revisionManager6 = ConfigurationManager.isRevisionManager6(propagationTechnique.getSolver().getLevelInResolution(), propagationTechnique.getPhase());
        Constraint[] constraints = propagationTechnique.getSolver().getProblem().getConstraints();
        this.supportUnits = new SupportUnit[constraints.length][];
        Constraint[] constraintArray = constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!revisionManager6 || !(constraint.getExtensionStructure() instanceof Bits)) {
                int j;
                SupportUnit[] t = new SupportUnit[constraint.getNbInvolvedVariables()];
                if (t.length == 1) {
                    t[0] = new SupportUnitUnaryConstraint(this, constraint, constraint.getInvolvedVariable(0));
                } else if (t.length == 2) {
                    if (this.recordFirst) {
                        t[0] = new SupportUnit2005bN(this, constraint, constraint.getInvolvedVariable(0));
                        t[1] = new SupportUnit2005bN(this, constraint, constraint.getInvolvedVariable(1));
                    } else {
                        t[0] = new SupportUnit2005b(this, constraint, constraint.getInvolvedVariable(0));
                        t[1] = new SupportUnit2005b(this, constraint, constraint.getInvolvedVariable(1));
                    }
                } else if (this.recordFirst) {
                    j = 0;
                    while (j < t.length) {
                        t[j] = new SupportUnit2005N(this, constraint, constraint.getInvolvedVariable(j));
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < t.length) {
                        t[j] = new SupportUnit2005(this, constraint, constraint.getInvolvedVariable(j));
                        ++j;
                    }
                }
                this.supportUnits[constraint.getId()] = t;
            }
            ++n;
        }
    }

    public void initializeStructures() {
        int i = 0;
        while (i < this.supportUnits.length) {
            if (this.supportUnits[i] != null) {
                int j = 0;
                while (j < this.supportUnits[i].length) {
                    this.supportUnits[i][j].initialize();
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean seekNextSupport(int constraintId, int variablePosition, int index) {
        Problem problem = this.propagationTechnique.getSolver().getProblem();
        if (this.supportUnits[constraintId] == null) {
            Constraint constraint = this.propagationTechnique.getSolver().getConstraint(constraintId);
            long[] t1 = ((Bits)constraint.getExtensionStructure()).getBinaryRepresentationOfSupportsOf(variablePosition, index);
            long[] t2 = constraint.getInvolvedVariable(variablePosition == 0 ? 1 : 0).getDomain().getElements().getBinaryRepresentation();
            int i = 0;
            while (i < t1.length) {
                problem.incrementNbConstraintChecks();
                if ((t1[i] & t2[i]) != 0L) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.supportUnits[constraintId][variablePosition].getArcSupportOf(index);
    }

    public void restoreSupportsOf(Constraint constraint, Variable variable, int depthLimit) {
    }

    public void restoreSupportsOfFutureVariables(int depthLimit) {
    }

    public void initAfterModificationOf(Variable variable, boolean progression, int depthLimitToUpdateStructures) {
    }

    public boolean controlSupports() {
        return true;
    }
}

