/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Bits;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2003b;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitUnaryConstraint;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;

public class SupportManager2003
extends SupportManagerOptimal {
    public void attachTo(PropagationTechnique propagationTechnique) {
        if (propagationTechnique.getSolver().getProblem().getMaxConstraintArity() != 2) {
            throw new IncompatiblePropertiesException();
        }
        if (propagationTechnique.getSolver() instanceof SystematicSolver && ((SystematicSolver)propagationTechnique.getSolver()).getBacktrackingMode() == 12) {
            throw new IncompatiblePropertiesException();
        }
        super.attachTo(propagationTechnique);
        boolean revisionManager6 = ConfigurationManager.isRevisionManager6(propagationTechnique.getSolver().getLevelInResolution(), propagationTechnique.getPhase());
        Constraint[] constraints = propagationTechnique.getSolver().getProblem().getConstraints();
        this.supportUnits = new SupportUnit[constraints.length][];
        Constraint[] constraintArray = constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!revisionManager6 || !(constraint.getExtensionStructure() instanceof Bits)) {
                SupportUnit[] t = new SupportUnit[constraint.getNbInvolvedVariables()];
                if (t.length == 1) {
                    t[0] = new SupportUnitUnaryConstraint(this, constraint, constraint.getInvolvedVariable(0));
                } else {
                    assert (t.length == 2);
                    t[0] = new SupportUnit2003b(this, constraint, constraint.getInvolvedVariable(0));
                    t[1] = new SupportUnit2003b(this, constraint, constraint.getInvolvedVariable(1));
                }
                this.supportUnits[constraint.getId()] = t;
            }
            ++n;
        }
    }

    private void updateSupportsOfRemovedValue(Variable variable, int index) {
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            this.supportUnits[constraint.getId()][constraint.getPositionOf(variable)].updateAfterRemovalOf(index);
            ++n;
        }
    }

    private void updateSupportsOfRemovedValues(Variable variable) {
        int depth = this.propagationTechnique.getSolver().getCurrentDepth();
        Elements elements = variable.getDomain().getElements();
        int index = elements.getLastAbsent();
        while (index != -1) {
            int removalDepth = elements.getAbsentLevelOf(index);
            if (removalDepth < depth) break;
            this.updateSupportsOfRemovedValue(variable, index);
            index = elements.getPrevAbsent(index);
        }
    }

    public void initAfterModificationOf(Variable variable, boolean progression, int depthLimitToUpdateStructures) {
        this.updateSupportsOfRemovedValues(variable);
        super.initAfterModificationOf(variable, progression, depthLimitToUpdateStructures);
    }
}

