/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;

public abstract class SupportManager {
    protected PropagationTechnique propagationTechnique;
    protected SupportUnit[][] supportUnits;
    protected boolean candidateAttentive;
    protected boolean stackSupports;
    protected boolean dynamicBacktracking;
    protected boolean relationFiltering;
    protected int[] lastDepths;

    public boolean getRelationFiltering() {
        return this.relationFiltering;
    }

    public void setRelationFiltering(boolean relationFiltering) {
        this.relationFiltering = relationFiltering;
    }

    public PropagationTechnique getPropagationTechnique() {
        return this.propagationTechnique;
    }

    public SupportUnit[][] getSupportUnits() {
        return this.supportUnits;
    }

    public SupportUnit[] getSupportUnitsOf(Constraint constraint) {
        return this.supportUnits[constraint.getId()];
    }

    public SupportUnit getSupportUnitOf(Constraint constraint, Variable variable) {
        return this.supportUnits[constraint.getId()][constraint.getPositionOf(variable)];
    }

    public boolean isCandidateAttentive() {
        return this.candidateAttentive;
    }

    public boolean mustStackSupports() {
        return this.stackSupports;
    }

    public boolean isSolverUsingDynamicBacktracking() {
        return this.dynamicBacktracking;
    }

    public void attachTo(PropagationTechnique propagationTechnique) {
        this.propagationTechnique = propagationTechnique;
        if (propagationTechnique.getSolver() instanceof SystematicSolver) {
            this.dynamicBacktracking = ((SystematicSolver)propagationTechnique.getSolver()).getBacktrackingMode() == 12;
        }
        String s = "propagationTechnique/supportManager";
        this.candidateAttentive = ConfigurationManager.getBoolean(propagationTechnique.getLevel(), String.valueOf(propagationTechnique.getPhase()) + "/" + s, "candidateAttentive");
        this.stackSupports = ConfigurationManager.getBoolean(propagationTechnique.getLevel(), String.valueOf(propagationTechnique.getPhase()) + "/" + s, "stackSupports");
    }

    public abstract void initializeStructures();

    public abstract boolean seekNextSupport(int var1, int var2, int var3);

    public abstract void restoreSupportsOf(Constraint var1, Variable var2, int var3);

    public abstract void restoreSupportsOfFutureVariables(int var1);

    public abstract void initAfterModificationOf(Variable var1, boolean var2, int var3);

    public abstract boolean controlSupports();

    public void display() {
        System.out.println("Support Manager");
        int i = 0;
        while (i < this.supportUnits.length) {
            int j = 0;
            while (j < this.supportUnits[i].length) {
                this.supportUnits[i][j].display();
                ++j;
            }
            ++i;
        }
        System.out.println();
    }
}

