/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.substitutabilityManagers;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSetOfVariables;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubstitutabilityManager {
    protected ForwardPropagationTechnique forwardPropagationTechnique;
    private PropagationSetOfVariables set;

    public SubstitutabilityManager() {
    }

    public SubstitutabilityManager(ForwardPropagationTechnique forwardPropagationTechnique) {
        this.forwardPropagationTechnique = forwardPropagationTechnique;
        this.set = new PropagationSetOfVariables();
        this.set.attachTo(forwardPropagationTechnique);
    }

    public abstract boolean isSubstitutableBy(Variable var1, int var2, int var3);

    public boolean isSubstitutable(Variable variable, int index) {
        Elements elements = variable.getDomain().getElements();
        int otherIndex = elements.getFirstPresent();
        while (otherIndex != -1) {
            if (otherIndex != index && this.isSubstitutableBy(variable, index, otherIndex)) {
                return true;
            }
            otherIndex = elements.getNextPresent(otherIndex);
        }
        return false;
    }

    public int removeSubstitutableValuesOf(Variable variable) {
        Domain domain = variable.getDomain();
        int domainSizebefore = domain.getCurrentSize();
        Elements elements = domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (this.isSubstitutable(variable, index)) {
                domain.removeElementAt(index);
            }
            index = elements.getNextPresent(index);
        }
        int nbRemovals = domainSizebefore - domain.getCurrentSize();
        if (nbRemovals > 0) {
            System.out.println(" => " + nbRemovals + " removals from " + variable + " at level " + variable.getProblem().getSolver().getCurrentDepth());
        }
        return nbRemovals;
    }

    public final void removeSubstitutableValues() {
        int nbRemovals;
        this.set.clear();
        VariableManager variableManager = this.forwardPropagationTechnique.getSolver().getVariableManager();
        Variable futureVariable = variableManager.getFirstFutureVariable();
        while (futureVariable != null) {
            nbRemovals = this.removeSubstitutableValuesOf(futureVariable);
            if (nbRemovals > 0) {
                this.set.addNeighboursOf(futureVariable);
            }
            futureVariable = variableManager.getNextFutureVariableAfter(futureVariable);
        }
        while (this.set.size() > 0) {
            Variable variable = this.set.getFirstVariable();
            this.set.remove(0);
            nbRemovals = this.removeSubstitutableValuesOf(variable);
            if (nbRemovals <= 0) continue;
            this.set.addNeighboursOf(variable);
        }
    }

    public int computeNbSubstitutableValuesOf(Variable variable) {
        int cpt = 0;
        Elements elements = variable.getDomain().getElements();
        int index1 = elements.getFirstPresent();
        while (index1 != -1) {
            int index2 = elements.getFirstPresent();
            while (index2 != -1) {
                if (index2 != index1 && this.isSubstitutableBy(variable, index1, index2)) {
                    ++cpt;
                }
                index2 = elements.getNextPresent(index2);
            }
            index1 = elements.getNextPresent(index1);
        }
        return cpt;
    }

    public double computeSubstitutabilityRatioOf(Problem problem) {
        double globalRatio = 0.0;
        Constraint[] constraintArray = problem.getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            double ratio = 0.0;
            Variable[] variableArray = constraint.getInvolvedVariables();
            int n3 = 0;
            int n4 = variableArray.length;
            while (n3 < n4) {
                Variable variable = variableArray[n3];
                long size = constraint.computeNbSubstitutableValuesOf(variable);
                long domainSize = variable.getCurrentDomainSize();
                ratio += (double)size / ((double)(domainSize * domainSize) - (double)domainSize);
                ++n3;
            }
            globalRatio += ratio / (double)constraint.getNbInvolvedVariables();
            ++n;
        }
        return globalRatio / (double)problem.getNbConstraints();
    }

    public List<int[]> computeSubstitutabilityRelationOf(Variable variable) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        Elements elements = variable.getDomain().getElements();
        int index1 = elements.getFirstPresent();
        while (index1 != -1) {
            int index2 = elements.getFirstPresent();
            while (index2 != -1) {
                if (index2 != index1 && this.isSubstitutableBy(variable, index1, index2)) {
                    list.add(new int[]{index1, index2});
                }
                index2 = elements.getNextPresent(index2);
            }
            index1 = elements.getNextPresent(index1);
        }
        return list;
    }

    public void displaySubstitutabilityRelationsOf(Problem problem) {
        Variable[] variableArray = problem.getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            List<int[]> list = this.computeSubstitutabilityRelationOf(variable);
            System.out.print("  Substitutability relation of " + variable + " = {");
            for (int[] t : list) {
                System.out.print(" " + t[0] + "<" + t[1]);
            }
            System.out.println(" }");
            ++n;
        }
    }
}

