/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers.revisionUnits;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.revisionManagers.RevisionManager;
import abscon.propagationTechniques.revisionManagers.RevisionManager2;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit1;
import abscon.tools.elements.Elements;

public class RevisionUnit2
extends RevisionUnit1 {
    private boolean currentDomainMode;
    private int[][] supports;
    private int[] nbSupports;
    private int[] nbConflicts;
    protected int[] sortedIndexes;
    protected int[][] nexts;
    protected int[][] prevs;
    private int coveringLimit = -10;
    private Variable secondVariable;
    private Domain secondDomain;
    int secondVariablePosition;
    int reviseNumber = 0;
    protected int[] supportInformation;
    RevisionUnit2 secondRevisionUnit;

    public RevisionUnit2(RevisionManager revisionManager, Constraint constraint, Variable variable) {
        super(revisionManager, constraint, variable);
        assert (constraint.getArity() == 2);
        this.currentDomainMode = ((RevisionManager2)revisionManager).isCurrentDomainMode();
        this.secondVariable = constraint.getFirstVariableDifferentFrom(variable);
        this.secondDomain = this.secondVariable.getDomain();
        this.secondVariablePosition = constraint.getPositionOf(this.secondVariable);
        this.supports = new int[variable.getDomain().getMaximumSize()][this.secondVariable.getDomain().getMaximumSize()];
        this.nbSupports = new int[variable.getDomain().getMaximumSize()];
        this.nbConflicts = new int[variable.getDomain().getMaximumSize()];
        this.supportInformation = new int[variable.getDomain().getMaximumSize()];
    }

    public void storeNewSupport(int[] tuple) {
        int index = tuple[this.variablePosition];
        int support = tuple[(this.variablePosition + 1) % 2];
        int n = index;
        int n2 = this.nbSupports[n];
        this.nbSupports[n] = n2 + 1;
        this.supports[index][n2] = support;
    }

    public void fixNbConflicts() {
        Elements elements = this.domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            this.nbConflicts[index] = this.secondVariable.getCurrentDomainSize() - this.nbSupports[index];
            index = elements.getNextPresent(index);
        }
        assert (this.controlOrderOfSupports());
    }

    private int computeCoveringLimit() {
        int limit = this.sortedIndexes.length - 1;
        Elements secondElements = this.secondDomain.getElements();
        int otherIndex = secondElements.getFirstPresent();
        while (otherIndex != -1) {
            int i = this.sortedIndexes.length - 1;
            while (i >= 0) {
                int index = this.sortedIndexes[i];
                boolean found = false;
                int k = 0;
                while (!found && k < this.nbSupports[index]) {
                    if (this.supports[index][k] == otherIndex) {
                        found = true;
                    } else if (this.supports[index][k] > otherIndex) break;
                    ++k;
                }
                if (found) {
                    limit = Math.min(limit, i);
                    break;
                }
                --i;
            }
            otherIndex = secondElements.getNextPresent(otherIndex);
        }
        return limit;
    }

    private boolean isLessThan(int index1, int index2) {
        int cursor2 = 0;
        int i = 0;
        while (i < this.nbSupports[index1]) {
            int support1 = this.supports[index1][i];
            while (cursor2 < this.nbSupports[index2] && this.supports[index2][cursor2] < support1) {
                ++cursor2;
            }
            if (cursor2 == this.nbSupports[index2] || this.supports[index2][cursor2] > support1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void buildNexts() {
        this.nexts = new int[this.domain.getMaximumSize()][];
        int[] tmp = new int[this.sortedIndexes.length - 1];
        int i = 0;
        while (i < this.sortedIndexes.length) {
            int otherIndex;
            int j;
            int index = this.sortedIndexes[i];
            int nb = 0;
            if (this.currentDomainMode) {
                j = i - 1;
                while (j >= 0) {
                    otherIndex = this.sortedIndexes[j];
                    if (this.nbSupports[index] != this.nbSupports[otherIndex]) break;
                    if (otherIndex >= index && this.isLessThan(index, otherIndex)) {
                        tmp[nb++] = otherIndex;
                    }
                    --j;
                }
            }
            j = i + 1;
            while (j < this.sortedIndexes.length) {
                otherIndex = this.sortedIndexes[j];
                if ((!this.currentDomainMode || otherIndex >= index) && this.isLessThan(index, otherIndex)) {
                    tmp[nb++] = otherIndex;
                }
                ++j;
            }
            this.nexts[index] = new int[nb];
            System.arraycopy(tmp, 0, this.nexts[index], 0, nb);
            ++i;
        }
    }

    private void buildPrevs() {
        this.prevs = new int[this.domain.getMaximumSize()][];
        int[] tmp = new int[this.sortedIndexes.length - 1];
        int i = 0;
        while (i < this.sortedIndexes.length) {
            int otherIndex;
            int index = this.sortedIndexes[i];
            int nb = 0;
            int j = i + 1;
            while (j < this.sortedIndexes.length) {
                otherIndex = this.sortedIndexes[j];
                if (this.nbSupports[index] != this.nbSupports[otherIndex]) break;
                if ((!this.currentDomainMode || otherIndex >= index) && this.isLessThan(otherIndex, index)) {
                    tmp[nb++] = otherIndex;
                }
                ++j;
            }
            if (this.currentDomainMode) {
                j = 0;
                while (j < i) {
                    otherIndex = this.sortedIndexes[j];
                    if (otherIndex >= index && this.isLessThan(otherIndex, index)) {
                        tmp[nb++] = otherIndex;
                    }
                    ++j;
                }
            }
            this.prevs[index] = new int[nb];
            System.arraycopy(tmp, 0, this.prevs[index], 0, nb);
            ++i;
        }
    }

    public void sortIndexes() {
        this.secondRevisionUnit = (RevisionUnit2)this.revisionManager.getRevisions(this.constraint, this.secondVariablePosition);
        Elements elements = this.domain.getElements();
        boolean[] sorted = new boolean[this.nbConflicts.length];
        this.sortedIndexes = new int[this.variable.getCurrentDomainSize()];
        int i = 0;
        while (i < this.sortedIndexes.length) {
            int bestIndex = -1;
            int index = elements.getFirstPresent();
            while (index != -1) {
                if (!(sorted[index] || bestIndex != -1 && this.nbSupports[index] >= this.nbSupports[bestIndex])) {
                    bestIndex = index;
                }
                index = elements.getNextPresent(index);
            }
            this.sortedIndexes[i] = bestIndex;
            sorted[bestIndex] = true;
            ++i;
        }
        this.buildNexts();
        this.buildPrevs();
        this.coveringLimit = this.computeCoveringLimit();
        assert (this.controlCoveringLimit());
    }

    public boolean mustBeRevised() {
        if (!super.mustBeRevised()) {
            return false;
        }
        if (this.secondRevisionUnit.coveringLimit == -10) {
            return true;
        }
        if (this.secondRevisionUnit.coveringLimit >= this.secondRevisionUnit.sortedIndexes.length - 3) {
            int j = this.secondRevisionUnit.coveringLimit;
            while (j < this.secondRevisionUnit.sortedIndexes.length) {
                if (!this.secondDomain.hasIndex(this.secondRevisionUnit.sortedIndexes[j])) {
                    return true;
                }
                ++j;
            }
            return false;
        }
        return true;
    }

    private void reviseIndex(int index) {
        if (this.secondVariable.getCurrentDomainSize() > this.nbConflicts[index]) {
            return;
        }
        if (this.supportInformation[index] == this.reviseNumber) {
            return;
        }
        if (this.supportInformation[index] == -this.reviseNumber) {
            this.domain.removeElementAt(index, this.constraint);
        } else if (!this.supportManager.seekNextSupport(this.constraint.getId(), this.variablePosition, index)) {
            this.domain.removeElementAt(index, this.constraint);
            int j = 0;
            while (j < this.prevs[index].length) {
                this.supportInformation[this.prevs[index][j]] = -this.reviseNumber;
                ++j;
            }
        } else {
            int j = 0;
            while (j < this.nexts[index].length) {
                this.supportInformation[this.nexts[index][j]] = this.reviseNumber;
                ++j;
            }
        }
    }

    private void reviseWithCurrentDomain() {
        Elements elements = this.domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            this.reviseIndex(index);
            index = elements.getNextPresent(index);
        }
    }

    private void reviseWithSortedIndexes() {
        int i = 0;
        while (i < this.sortedIndexes.length) {
            int index = this.sortedIndexes[i];
            if (this.domain.hasIndex(index)) {
                this.reviseIndex(index);
            }
            ++i;
        }
    }

    public void revise() {
        if (this.sortedIndexes == null) {
            super.revise();
        } else {
            ++this.reviseNumber;
            if (this.currentDomainMode) {
                this.reviseWithCurrentDomain();
            } else {
                this.reviseWithSortedIndexes();
            }
        }
    }

    public void display() {
        super.display();
        System.out.print("  nbSupports : ");
        Elements elements = this.domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            System.out.print(String.valueOf(index) + "->" + this.nbSupports[index] + " ");
            index = elements.getNextPresent(index);
        }
        System.out.print("\n  sortedIndexes = ");
        int i = 0;
        while (i < this.sortedIndexes.length) {
            int index2 = this.sortedIndexes[i];
            System.out.print(" " + index2);
            int j = 0;
            while (j < this.nexts[index2].length) {
                System.out.print(String.valueOf(j == 0 ? "<{" : "") + this.nexts[index2][j] + (j == this.nexts[index2].length - 1 ? "}" : ","));
                ++j;
            }
            ++i;
        }
        System.out.println(" covering limit = " + this.computeCoveringLimit());
    }

    private boolean controlOrderOfSupports() {
        int i = 0;
        while (i < this.supports.length) {
            int j = 0;
            while (j < this.nbSupports[i] - 1) {
                if (this.supports[i][j] > this.supports[i][j + 1]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean controlCoveringLimit() {
        int[] tuple = new int[2];
        int i = 0;
        while (i < this.secondVariable.getCurrentDomainSize()) {
            tuple[this.constraint.getPositionOf((Variable)this.secondVariable)] = i;
            boolean found = false;
            int j = this.coveringLimit;
            while (!found && j < this.sortedIndexes.length) {
                tuple[this.variablePosition] = this.sortedIndexes[j];
                if (this.constraint.checkTupleOfIndexes(tuple)) {
                    found = true;
                }
                ++j;
            }
            if (!found && this.secondRevisionUnit.nbSupports[i] != 0) {
                System.out.println("Error " + this.constraint + " " + this.variable + " " + i + " " + this.secondRevisionUnit.nbSupports[i]);
                return false;
            }
            ++i;
        }
        return true;
    }
}

