/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets.revisionOrderingHeuristics;

import abscon.constants.AbsconConstants;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.Random;

public abstract class RevisionOrderingHeuristic {
    protected PropagationSet propagationSet;
    protected AbsconConstants.MinMaxNo optimization;
    protected int limit;
    protected int lazyCpt;
    protected double bestEvaluation;
    protected Random random;

    public PropagationSet getPropagationSet() {
        return this.propagationSet;
    }

    public void setLazyCpt(int v) {
        this.lazyCpt = v;
    }

    public void attachTo(PropagationSet propagationSet) {
        this.propagationSet = propagationSet;
        int level = propagationSet.getPropagationTechnique().getLevel();
        String phase = propagationSet.getPropagationTechnique().getPhase();
        String prefix = "propagationTechnique/propagationSet/revisionHeuristic";
        String s = ConfigurationManager.getString(level, String.valueOf(phase) + "/" + prefix, "optim");
        this.optimization = AbsconConstants.MinMaxNo.getOptimizationFor(s);
        this.limit = ConfigurationManager.getInt(level, String.valueOf(phase) + "/" + prefix, "limit");
        if (this.limit == -1) {
            this.limit = Integer.MAX_VALUE;
        }
        this.random = propagationSet.getPropagationTechnique().getSolver().getResolution().getRandom();
    }

    public void initAfterModificationOf(Variable variable) {
    }

    protected double evaluate(int position) {
        throw new MissingImplementationException();
    }

    protected double computeEvaluationOf(int position) {
        double d = this.evaluate(position);
        return this.optimization.isMin() ? -d : d;
    }

    protected int getUnlazyIndexOfBestPropagationElement() {
        this.bestEvaluation = this.computeEvaluationOf(0);
        int bestIndex = 0;
        int frontier = Math.min(this.limit, this.propagationSet.size());
        int i = 1;
        while (i < frontier) {
            double evaluation = this.computeEvaluationOf(i);
            if (evaluation > this.bestEvaluation) {
                this.bestEvaluation = evaluation;
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    public int getIndexOfBestPropagationElement() {
        if (this.lazyCpt > 0) {
            --this.lazyCpt;
            return 0;
        }
        return this.getUnlazyIndexOfBestPropagationElement();
    }
}

