/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSetOfVariables;
import abscon.solvers.systematicSolvers.NogoodManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;

public class PropagationSetOfVariablesNogood
extends PropagationSetOfVariables {
    private NogoodManager nogoodManager;
    private int[] absentValuesSentinel;
    private int[] sentinelLevel;
    private NogoodManager.NogoodConfiguration nogoodRecordingMode;

    public void setNogoodManager(NogoodManager nogoodManager) {
        this.nogoodManager = nogoodManager;
    }

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        this.nogoodRecordingMode = NogoodManager.NogoodConfiguration.getNogoodConfigurationFor(ConfigurationManager.getInt(propagationTechnique.getSolver().getLevelInResolution(), "search/nogoodRecording", "mode"));
        if (this.nogoodRecordingMode == NogoodManager.NogoodConfiguration.NO_NOGOOD_RECORDING) {
            throw new IncompatiblePropertiesException();
        }
        if (this.nogoodRecordingMode == NogoodManager.NogoodConfiguration.PEIGNE_RECORDING) {
            return;
        }
        this.absentValuesSentinel = new int[propagationTechnique.getSolver().getNbVariables()];
        this.sentinelLevel = new int[propagationTechnique.getSolver().getNbVariables()];
    }

    private boolean isNogoodConsistent(Variable variable) {
        boolean consistent;
        if (this.nogoodManager == null) {
            return true;
        }
        if (this.propagationTechnique.getSolver().getResolution().getAuxiliarySolver() == this.propagationTechnique.getSolver()) {
            return true;
        }
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        if (elements.getNbPresentElements() == 1 && !(consistent = this.nogoodManager.checkWatchesOf(variable, elements.getFirstPresent(), false))) {
            return false;
        }
        if (this.nogoodRecordingMode == NogoodManager.NogoodConfiguration.PEIGNE_RECORDING) {
            return true;
        }
        if (this.sentinelLevel[variable.getId()] != this.propagationTechnique.getSolver().getNbVisitedNodes()) {
            this.absentValuesSentinel[variable.getId()] = -1;
        }
        int depth = this.propagationTechnique.getSolver().getCurrentDepth();
        int last = elements.getLastAbsent();
        int index = elements.getLastAbsent();
        while (index != this.absentValuesSentinel[variable.getId()]) {
            if (elements.getAbsentLevelOf(index) < depth) break;
            if (!this.nogoodManager.checkWatchesOf(variable, index, true)) {
                return false;
            }
            index = elements.getPrevAbsent(index);
        }
        this.sentinelLevel[variable.getId()] = this.propagationTechnique.getSolver().getNbVisitedNodes();
        this.absentValuesSentinel[variable.getId()] = last;
        return true;
    }

    public boolean pickElementAndCheckConsistency() {
        int selection = this.revisionOrderingHeuristic.getIndexOfBestPropagationElement();
        Variable variable = this.getVariable(selection);
        this.remove(selection);
        if (!this.isNogoodConsistent(variable)) {
            return false;
        }
        ((ForwardPropagationTechnique)this.propagationTechnique).getRevisionManager().reinitAccessFor(variable);
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.propagationTechnique.admits(constraint) && constraint.getDomainManager().hasRecentReducedDomain(variable) && !this.propagationTechnique.isConsistent(constraint)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

