/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import java.util.Arrays;

public class PropagationSetOfReversesComp
extends PropagationSet {
    private int[][] positionOfElements;
    private Constraint[][] arcs;
    private int[] nbArcs;
    private Constraint c;

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        Variable[] variables = propagationTechnique.getSolver().getVariables();
        Constraint[] constraints = propagationTechnique.getSolver().getConstraints();
        this.positionOfElements = new int[constraints.length][];
        int i = 0;
        while (i < this.positionOfElements.length) {
            this.positionOfElements[i] = new int[constraints[i].getArity()];
            ++i;
        }
        this.arcs = new Constraint[variables.length][];
        i = 0;
        while (i < this.arcs.length) {
            this.arcs[i] = new Constraint[variables[i].getNbInvolvingConstraints()];
            ++i;
        }
        this.nbArcs = new int[variables.length];
        this.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.positionOfElements.length) {
            Arrays.fill(this.positionOfElements[i], -1);
            ++i;
        }
        Arrays.fill(this.nbArcs, 0);
        this.size = 0;
    }

    private void updateFrom(Variable variable) {
        assert (!variable.isAssigned());
        Constraint[] constraints = variable.getInvolvingConstraints();
        int j = 0;
        while (j < constraints.length) {
            if (this.propagationTechnique.admits(constraints[j])) {
                this.add(variable, constraints[j]);
            }
            ++j;
        }
    }

    public void fill() {
        Variable[] variables = this.propagationTechnique.getSolver().getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].isAssigned()) {
                this.updateFrom(variables[i]);
            }
            ++i;
        }
    }

    private void updateFrom(Constraint constraint, Variable revisedVariable) {
        Variable futureVariable = constraint.getFirstFutureVariable();
        while (futureVariable != null) {
            if (futureVariable != revisedVariable || this.propagationTechnique.isBoundConsistency()) {
                this.add(futureVariable, constraint);
            }
            futureVariable = constraint.getNextFutureVariableAfter(futureVariable);
        }
    }

    public void initAfterModificationOf(Variable variable) {
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.propagationTechnique.admits(constraint)) {
                this.updateFrom(constraint, variable);
            }
            ++n;
        }
    }

    private int selectBestVariableId2() {
        Variable[] variables = this.propagationTechnique.getSolver().getVariables();
        int bestId = -1;
        int bestValue = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.nbArcs.length) {
            int value;
            if (this.nbArcs[i] != 0 && (value = variables[i].getCurrentDomainSize()) <= bestValue && (value < bestValue || this.nbArcs[i] > this.nbArcs[bestId])) {
                bestId = i;
                bestValue = value;
            }
            ++i;
        }
        return bestId;
    }

    private Constraint selectAndRemoveBestConstraintIn(Constraint[] constraints, int nbConstraints) {
        int bestConstraintPosition = 0;
        double bestValue = constraints[0].getDomainManager().getDCurrentDomainSize();
        int i = 1;
        while (i < nbConstraints) {
            double value = constraints[i].getDomainManager().getDCurrentDomainSize();
            if (value < bestValue) {
                bestConstraintPosition = i;
                bestValue = value;
            }
            ++i;
        }
        Constraint bestConstraint = constraints[bestConstraintPosition];
        constraints[bestConstraintPosition] = constraints[nbConstraints - 1];
        constraints[nbConstraints - 1] = bestConstraint;
        return bestConstraint;
    }

    public boolean pickElementAndCheckConsistency() {
        Constraint constraint;
        this.c = null;
        int idVariable = this.selectBestVariableId2();
        Variable variable = this.propagationTechnique.getSolver().getVariable(idVariable);
        int domainSizeBefore = variable.getCurrentDomainSize();
        int i = this.nbArcs[idVariable];
        while (i > 0) {
            constraint = this.selectAndRemoveBestConstraintIn(this.arcs[idVariable], i);
            assert (this.propagationTechnique.admits(constraint));
            if (!this.propagationTechnique.isConsistent(constraint, variable)) {
                return false;
            }
            --i;
        }
        this.remove(idVariable);
        int domainSizeAfter = variable.getCurrentDomainSize();
        if (domainSizeAfter != domainSizeBefore) {
            assert (this.c != null);
            if (this.c == Constraint.TAG) {
                this.initAfterModificationOf(variable);
            } else {
                Constraint[] constraintArray = variable.getInvolvingConstraints();
                int n = 0;
                int n2 = constraintArray.length;
                while (n < n2) {
                    constraint = constraintArray[n];
                    if (this.propagationTechnique.admits(constraint) && (constraint != this.c || this.useBackRevisions())) {
                        this.updateFrom(constraint, variable);
                    }
                    ++n;
                }
            }
        }
        return true;
    }

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable revisedVariable, int nbRemovals) {
        if (!this.propagationTechnique.isMultiPass()) {
            return;
        }
        this.c = this.c == null ? constraint : Constraint.TAG;
    }

    private void add(Variable variable, Constraint constraint) {
        int variablePosition = constraint.getPositionOf(variable);
        if (this.positionOfElements[constraint.getId()][variablePosition] != -1) {
            return;
        }
        int id = variable.getId();
        this.positionOfElements[constraint.getId()][variablePosition] = this.nbArcs[id];
        this.arcs[id][this.nbArcs[id]] = constraint;
        int n = id;
        this.nbArcs[n] = this.nbArcs[n] + 1;
        ++this.size;
    }

    public void remove(int id) {
        assert (this.nbArcs[id] > 0);
        Variable[] variables = this.propagationTechnique.getSolver().getVariables();
        int i = 0;
        while (i < this.nbArcs[id]) {
            Constraint constraint = this.arcs[id][i];
            assert (this.positionOfElements[constraint.getId()][constraint.getPositionOf(variables[id])] != -1);
            this.positionOfElements[constraint.getId()][constraint.getPositionOf((Variable)variables[id])] = -1;
            ++i;
        }
        this.size -= this.nbArcs[id];
        this.nbArcs[id] = 0;
    }

    public void swap(int i, int j) {
        throw new UnreachableCodeException();
    }

    public boolean controlClear() {
        if (this.size != 0) {
            return false;
        }
        int i = 0;
        while (i < this.positionOfElements.length) {
            int j = 0;
            while (j < this.positionOfElements[i].length) {
                if (this.positionOfElements[i][j] != -1) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbArcs.length) {
            if (this.nbArcs[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void display() {
    }
}

