/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;

public class PropagationSetOfConstraints
extends PropagationSet {
    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        this.capacity = propagationTechnique.getSolver().getProblem().getNbConstraints();
        this.positionOfElements = new int[this.capacity];
        this.constraints = new Constraint[this.capacity];
        this.clear();
    }

    public void fill() {
        Constraint[] constraints = this.propagationTechnique.getSolver().getConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (this.propagationTechnique.admits(constraints[i])) {
                this.add(constraints[i]);
            }
            ++i;
        }
        this.propagationTechnique.getSolver().getProblem().updateConstraintDomainManagers(1);
    }

    public void initAfterModificationOf(Variable variable) {
        Constraint[] constraints = variable.getInvolvingConstraints();
        int i = 0;
        while (i < constraints.length) {
            constraints[i].getDomainManager().setNbRecentDomainRemovals(variable, 1);
            if (this.propagationTechnique.admits(constraints[i])) {
                this.add(constraints[i]);
            }
            ++i;
        }
    }

    public boolean pickElementAndCheckConsistency() {
        int i = this.revisionOrderingHeuristic.getIndexOfBestPropagationElement();
        Constraint constraint = this.getConstraint(i);
        this.remove(i);
        return constraint.isConsistent();
    }

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable variable, int nbRemovals) {
        if (!this.propagationTechnique.isMultiPass()) {
            return;
        }
        Constraint[] constraints = variable.getInvolvingConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (constraints[i] != constraint || this.useBackRevisions()) {
                constraints[i].getDomainManager().incrementNbRecentDomainRemovals(variable, nbRemovals);
                if (this.propagationTechnique.admits(constraints[i]) && (constraints[i].getNbFutureVariables() != 1 || this.propagationTechnique.isBoundConsistency())) {
                    this.add(constraints[i]);
                }
            }
            ++i;
        }
    }

    protected void add(Constraint constraint) {
        int position;
        if (this.positionOfElements[constraint.getId()] != -1) {
            return;
        }
        this.positionOfElements[constraint.getId()] = position = (this.head + this.size) % this.capacity;
        this.constraints[position] = constraint;
        ++this.size;
    }

    public void remove(int i) {
        int position = (this.head + i) % this.capacity;
        Constraint constraint = this.constraints[position];
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else if (position != (this.head + this.size - 1) % this.capacity) {
            Constraint lastConstraint;
            this.constraints[position] = lastConstraint = this.getLastConstraint();
            this.positionOfElements[lastConstraint.getId()] = position;
        }
        this.positionOfElements[constraint.getId()] = -1;
        --this.size;
    }

    public void swap(int i, int j) {
        int pos1 = (this.head + i) % this.capacity;
        int pos2 = (this.head + j) % this.capacity;
        Constraint tmp = this.constraints[pos1];
        this.constraints[pos1] = this.constraints[pos2];
        this.constraints[pos2] = tmp;
        this.positionOfElements[this.constraints[pos1].getId()] = pos1;
        this.positionOfElements[this.constraints[pos2].getId()] = pos2;
    }

    public void display() {
        super.display();
        int i = 0;
        while (i < this.size) {
            System.out.print(this.getConstraint(i) + " ");
            ++i;
        }
        System.out.println();
    }
}

