/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.revisionOrderingHeuristics.RevisionOrderingHeuristic;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;
import java.util.Arrays;

public abstract class PropagationSet {
    protected PropagationTechnique propagationTechnique;
    protected RevisionOrderingHeuristic revisionOrderingHeuristic;
    protected Constraint[] constraints;
    protected Variable[] variables;
    protected int[] indexes;
    protected int size;
    protected int[] positionOfElements;
    protected int head;
    protected int capacity;

    public PropagationTechnique getPropagationTechnique() {
        return this.propagationTechnique;
    }

    public RevisionOrderingHeuristic getRevisionOrderingHeuristic() {
        return this.revisionOrderingHeuristic;
    }

    public int size() {
        return this.size;
    }

    public Constraint getConstraint(int i) {
        assert (this.size > 0);
        return this.constraints[(this.head + i) % this.capacity];
    }

    public Variable getVariable(int i) {
        assert (this.size > 0);
        return this.variables[(this.head + i) % this.capacity];
    }

    public int getIndex(int i) {
        assert (this.size > 0);
        return this.indexes[(this.head + i) % this.capacity];
    }

    public Constraint getFirstConstraint() {
        assert (this.size > 0);
        return this.constraints[this.head];
    }

    public Variable getFirstVariable() {
        assert (this.size > 0);
        return this.variables[this.head];
    }

    public int getFirstIndex() {
        assert (this.size > 0);
        return this.indexes[this.head];
    }

    public Constraint getLastConstraint() {
        assert (this.size > 0);
        return this.constraints[(this.head + this.size - 1) % this.capacity];
    }

    public Variable getLastVariable() {
        assert (this.size > 0);
        return this.variables[(this.head + this.size - 1) % this.capacity];
    }

    public int getLastIndex() {
        assert (this.size > 0);
        return this.indexes[(this.head + this.size - 1) % this.capacity];
    }

    public boolean useBackRevisions() {
        return this.propagationTechnique.getPathExtension();
    }

    public void attachTo(PropagationTechnique propagationTechnique) {
        this.propagationTechnique = propagationTechnique;
        String h = ConfigurationManager.getString(propagationTechnique.getLevel(), String.valueOf(propagationTechnique.getPhase()) + "/" + "propagationTechnique" + "/" + "propagationSet" + "/" + "revisionHeuristic", "class");
        this.revisionOrderingHeuristic = (RevisionOrderingHeuristic)Factory.getInstanceOf(h, RevisionOrderingHeuristic.class);
        this.revisionOrderingHeuristic.attachTo(this);
    }

    public void clear() {
        Arrays.fill(this.positionOfElements, -1);
        this.size = 0;
    }

    public abstract void fill();

    public abstract void initAfterModificationOf(Variable var1);

    public abstract boolean pickElementAndCheckConsistency();

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable variable, int nbRemovals) {
        throw new MissingImplementationException();
    }

    public abstract void remove(int var1);

    public void removeFirstElement() {
        assert (this.size() > 0);
        this.remove(0);
    }

    public void removeLastElement() {
        assert (this.size() > 0);
        this.remove(this.size - 1);
    }

    public void swap(int i, int j) {
        throw new MissingImplementationException();
    }

    public void display() {
        System.out.println("There are " + this.size + " elements");
    }

    public boolean controlClear() {
        if (this.size != 0) {
            return false;
        }
        int i = 0;
        while (i < this.positionOfElements.length) {
            if (this.positionOfElements[i] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

