/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.limited;

import abscon.constants.AbsconConstants;
import abscon.heuristics.variableOrdering.VariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyW
extends SingletonArcConsistency {
    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
    }

    private int filteringBySACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        if (this.boundConsistency) {
            while (elements.getNbPresentElements() > 0 && !this.singletonTest(variable, elements.getFirstPresent(), AbsconConstants.MinMaxNo.MIN)) {
                variable.getDomain().removeElementAt(elements.getFirstPresent());
            }
            while (elements.getNbPresentElements() > 1 && !this.singletonTest(variable, elements.getLastPresent(), AbsconConstants.MinMaxNo.MAX)) {
                variable.getDomain().removeElementAt(elements.getLastPresent());
            }
        } else {
            int index = elements.getFirstPresent();
            while (index != -1) {
                int nextIndex = elements.getNextPresent(index);
                if (!this.singletonTest(variable, index, AbsconConstants.MinMaxNo.NO)) {
                    variable.getDomain().removeElementAt(index);
                }
                index = nextIndex;
            }
        }
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    protected boolean filterBySAC() {
        VariableOrderingHeuristic voh = ((SystematicSolver)this.solver).getVariableOrderingHeuristic();
        this.inferenceManager.removeInferences();
        boolean modified = true;
        while (modified) {
            modified = false;
            Variable variable = voh.getNextVariable();
            int nbRemovals = this.filteringBySACOf(variable);
            if (nbRemovals > 0) {
                if (variable.getCurrentDomainSize() == 0) {
                    this.culprit = variable;
                    return false;
                }
                modified = true;
                if (!super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                    return false;
                }
            }
            if (!this.solver.getResolution().isFinished()) continue;
            return true;
        }
        return true;
    }
}

