/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.limited;

import abscon.constants.AbsconConstants;
import abscon.heuristics.valueOrdering.ValueSelected;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.substitutabilityManagers.SubstitutabilityManager;
import abscon.propagationTechniques.substitutabilityManagers.SubstitutabilityManager1;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencySelected
extends SingletonArcConsistency {
    private boolean test = true;
    private long[][][] records;
    private SubstitutabilityManager substitutabilityManager;

    protected void buildInferenceManager() {
        this.substitutabilityManager = new SubstitutabilityManager1();
    }

    protected boolean singletonTest(Variable futureVariable, int index, AbsconConstants.MinMaxNo mode) {
        ++this.nbSingletonTests;
        this.solver.doAssignment(futureVariable, index);
        boolean consistent = super.checkArcConsistencyAfterAssignmentOf(futureVariable);
        assert (!consistent || this.controlConsistency(false)) : "problem after singleton test: " + futureVariable + " = " + index;
        if (!consistent) {
            ++this.nbEffectiveSingletonTests;
        }
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        return consistent;
    }

    private int filteringBySACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        int smallestImpact = Integer.MAX_VALUE;
        int bestMinIndex = -1;
        int greatestImpact = -1;
        int bestMaxIndex = -1;
        int index = elements.getFirstPresent();
        while (index != -1) {
            int nextIndex = elements.getNextPresent(index);
            Domain.resetNbRemovals();
            if (!this.singletonTest(variable, index, AbsconConstants.MinMaxNo.NO)) {
                variable.getDomain().removeElementAt(index);
            } else {
                if (Domain.getNbRemovals() < smallestImpact) {
                    smallestImpact = Domain.getNbRemovals();
                    bestMinIndex = index;
                }
                if (Domain.getNbRemovals() > greatestImpact) {
                    greatestImpact = Domain.getNbRemovals();
                    bestMaxIndex = index;
                }
            }
            index = nextIndex;
        }
        ValueSelected.setBestValues(bestMinIndex, bestMaxIndex);
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    protected boolean filterBySAC() {
        if (this.solver.getVariableManager().getNbFutureVariables() == 0) {
            return true;
        }
        Object previousVariable = null;
        Variable variable = ((SystematicSolver)this.solver).getVariableOrderingHeuristic().getNextVariable();
        this.substitutabilityManager.removeSubstitutableValuesOf(variable);
        return true;
    }

    public boolean checkConsistency() {
        if (!super.checkArcConsistency()) {
            return false;
        }
        return this.filterBySAC();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        if (!super.checkArcConsistencyAfterAssignmentOf(variable)) {
            return false;
        }
        return this.filterBySAC();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        if (!super.checkArcConsistencyAfterRefutationOf(variable, variableDepth)) {
            return false;
        }
        return this.filterBySAC();
    }
}

