/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers;

import abscon.constants.AbsconConstants;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManager;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnit;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnitFull;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class InferenceManagerBoundFull
extends InferenceManager {
    protected int[] minBounds;
    protected int[] maxBounds;
    protected InferenceUnitFull[][][] inferenceUnits;

    public InferenceUnit getInferenceUnit(Variable variable1, int bnd, Variable variable2) {
        return this.inferenceUnits[variable1.getId()][bnd][variable2.getId()];
    }

    public InferenceManagerBoundFull(SingletonArcConsistency singletonArcConsistency) {
        super(singletonArcConsistency);
        Variable[] variables = singletonArcConsistency.getSolver().getVariables();
        int nbVariables = variables.length;
        this.inferenceUnits = new InferenceUnitFull[nbVariables][2][nbVariables];
        int i = 0;
        while (i < this.inferenceUnits.length) {
            int j = 0;
            while (j < this.inferenceUnits[i].length) {
                int k = 0;
                while (k < this.inferenceUnits[i][j].length) {
                    this.inferenceUnits[i][j][k] = new InferenceUnitFull(variables[k].getDomain().getElements().getMaximumSize());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.minBounds = new int[nbVariables];
        this.maxBounds = new int[nbVariables];
        Arrays.fill(this.minBounds, -1);
        Arrays.fill(this.maxBounds, -1);
    }

    public int whichBound(Variable variable, int index) {
        if (this.minBounds[variable.getId()] == index) {
            return 0;
        }
        if (this.maxBounds[variable.getId()] == index) {
            return 1;
        }
        return -1;
    }

    public boolean exploitInferences(Variable variable, int index) {
        assert (variable.isAssigned() && this.singletonArcConsistency.getPropagationSet().controlClear());
        int bound = this.whichBound(variable, index);
        if (bound == -1) {
            this.singletonArcConsistency.getPropagationSet().initAfterModificationOf(variable);
            return true;
        }
        if (this.inferenceUnits[variable.getId()][bound][variable.getId()].isModified()) {
            this.singletonArcConsistency.getPropagationSet().initAfterModificationOf(variable);
        }
        VariableManager variableManager = ((SystematicSolver)this.singletonArcConsistency.getSolver()).getVariableManager();
        Variable currentVariable = variableManager.getFirstFutureVariable();
        while (currentVariable != null) {
            InferenceUnitFull inferenceUnit = this.inferenceUnits[variable.getId()][bound][currentVariable.getId()];
            Domain domain = currentVariable.getDomain();
            Elements elements = domain.getElements();
            int currentIndex = elements.getFirstPresent();
            while (currentIndex != -1) {
                if (inferenceUnit.isAbsent(currentIndex)) {
                    domain.removeElementAt(currentIndex);
                }
                currentIndex = elements.getNextPresent(currentIndex);
            }
            if (domain.isEmpty()) {
                this.singletonArcConsistency.getPropagationSet().clear();
                return false;
            }
            if (inferenceUnit.isModified()) {
                this.singletonArcConsistency.getPropagationSet().initAfterModificationOf(currentVariable);
            }
            currentVariable = variableManager.getNextFutureVariableAfter(currentVariable);
        }
        return true;
    }

    public void updateInferences(Variable variable, int index, AbsconConstants.MinMaxNo mode) {
        int bound;
        assert (mode != AbsconConstants.MinMaxNo.NO && variable.isAssigned());
        int n = bound = mode.isMin() ? 0 : 1;
        if (bound == 0) {
            this.minBounds[variable.getId()] = index;
        } else {
            this.maxBounds[variable.getId()] = index;
        }
        VariableManager variableManager = ((SystematicSolver)this.singletonArcConsistency.getSolver()).getVariableManager();
        Variable currentVariable = variableManager.getFirstFutureVariable();
        while (currentVariable != null) {
            InferenceUnitFull inferenceUnit = this.inferenceUnits[variable.getId()][bound][currentVariable.getId()];
            inferenceUnit.clear(variable.getId(), index, currentVariable.getId());
            Elements elements = currentVariable.getDomain().getElements();
            int currentIndex = elements.getLastAbsent();
            while (currentIndex != -1) {
                inferenceUnit.addAbsent(currentIndex);
                currentIndex = elements.getPrevAbsent(currentIndex);
            }
            currentVariable = variableManager.getNextFutureVariableAfter(currentVariable);
        }
    }

    public void removeInferences() {
        int i = 0;
        while (i < this.inferenceUnits.length) {
            int j = 0;
            while (j < this.inferenceUnits[i].length) {
                int k = 0;
                while (k < this.inferenceUnits[i][j].length) {
                    this.inferenceUnits[i][j][k].clear(i, j, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Arrays.fill(this.minBounds, -1);
        Arrays.fill(this.maxBounds, -1);
    }
}

