/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.constants.AbsconConstants;
import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.Stopwatch;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyDomain
extends SingletonArcConsistency {
    private boolean maintainAC = false;
    private boolean onePass = false;

    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
    }

    private int filteringBySACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        if (this.boundConsistency) {
            while (elements.getNbPresentElements() > 0 && !this.singletonTest(variable, elements.getFirstPresent(), AbsconConstants.MinMaxNo.MIN)) {
                variable.getDomain().removeElementAt(elements.getFirstPresent());
                if (!this.maintainAC || elements.getNbPresentElements() <= 0 || super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) continue;
                return -1;
            }
            while (elements.getNbPresentElements() > 1 && !this.singletonTest(variable, elements.getLastPresent(), AbsconConstants.MinMaxNo.MAX)) {
                variable.getDomain().removeElementAt(elements.getLastPresent());
                if (!this.maintainAC || elements.getNbPresentElements() <= 0 || super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) continue;
                return -1;
            }
        } else {
            int index = elements.getFirstPresent();
            while (index != -1) {
                int nextIndex = elements.getNextPresent(index);
                if (!this.singletonTest(variable, index, AbsconConstants.MinMaxNo.NO)) {
                    variable.getDomain().removeElementAt(index);
                    if (this.maintainAC && elements.getNbPresentElements() > 0 && !super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                        return -1;
                    }
                }
                index = nextIndex;
            }
        }
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    protected boolean filterBySAC() {
        this.inferenceManager.removeInferences();
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        boolean modified = true;
        while (modified) {
            modified = false;
            VariableManager variableManager = this.solver.getVariableManager();
            Variable variable = variableManager.getFirstFutureVariable();
            while (variable != null) {
                if (variable.getCurrentDomainSize() < 6) {
                    int nbRemovals = this.filteringBySACOf(variable);
                    if (nbRemovals == -1) {
                        return false;
                    }
                    if (nbRemovals > 0) {
                        if (variable.getCurrentDomainSize() == 0) {
                            this.culprit = variable;
                            return false;
                        }
                        modified = true;
                        if (!this.maintainAC && !super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                            return false;
                        }
                    }
                }
                variable = variableManager.getNextFutureVariableAfter(variable);
            }
            if (!this.onePass) continue;
            modified = false;
            Constraint[] constraintArray = this.solver.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                constraint.resetWeightedDegree();
                ++n;
            }
            if (super.checkArcConsistency()) continue;
            return false;
        }
        assert (this.controlConsistency(false) && this.controlSingletonArcConsistency());
        return true;
    }
}

