/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.Branch;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.ExtendedBranch;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency3;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnitFull;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicStatistics;
import abscon.tools.elements.Elements;

public class SingletonArcConsistency3Plus
extends SingletonArcConsistency3 {
    private ExtendedBranch[] branches;
    private int nbBranches;
    private boolean mustMaintainAC = true;
    private int[] sizes;

    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        if (this.boundConsistency) {
            throw new IncompatiblePropertiesException();
        }
        this.branches = new ExtendedBranch[solver.getProblem().getNbMaxAssignments()];
        if (this.mustMaintainAC) {
            this.sizes = new int[solver.getNbVariables()];
        }
    }

    private boolean checkConsistencyOf(ExtendedBranch branch) {
        assert (this.propagationSet.controlClear() && branch.controlModified());
        if (!branch.isModified()) {
            return true;
        }
        if (branch.isInconsistent()) {
            return false;
        }
        int i = 0;
        while (i < branch.getCurrentSize()) {
            Variable variable = branch.getVariable(i);
            int index = branch.getIndex(i);
            assert (variable.getDomain().hasIndex(index));
            this.solver.doAssignment(variable, index);
            ((SystematicStatistics)this.solver.getStatistics()).decrementNbAssignments();
            ++i;
        }
        Variable[] variables = this.solver.getVariables();
        int i2 = 0;
        while (i2 < variables.length) {
            if (!variables[i2].isAssigned()) {
                assert (!branch.has(variables[i2]));
                InferenceUnitFull inferenceUnit = branch.getInferenceUnit(i2);
                Domain domain = variables[i2].getDomain();
                Elements elements = domain.getElements();
                int currentIndex = elements.getFirstPresent();
                while (currentIndex != -1) {
                    if (inferenceUnit.isAbsent(currentIndex)) {
                        domain.removeElementAt(currentIndex);
                    }
                    currentIndex = elements.getNextPresent(currentIndex);
                }
                if (domain.isEmpty()) {
                    this.propagationSet.clear();
                    this.undoAssignmentsFromBranch(branch);
                    return false;
                }
                if (inferenceUnit.isModified()) {
                    this.propagationSet.initAfterModificationOf(variables[i2]);
                }
            }
            ++i2;
        }
        assert (this.propagationSet.size() > 0);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        if (consistent) {
            branch.recordProblemDomain();
        }
        this.undoAssignmentsFromBranch(branch);
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        return consistent;
    }

    private void updateBranchesAfterRemovalOf(Variable variable, int index) {
        int i = 0;
        while (i < this.nbBranches) {
            this.branches[i].updateAfterRemovalOf(variable, index);
            ++i;
        }
    }

    private void updateQueueFromInconsistentBranches() {
        int cpt = 0;
        int i = 0;
        while (i < this.nbBranches) {
            ExtendedBranch branch = this.branches[i];
            if (!this.checkConsistencyOf(branch)) {
                int j = 0;
                while (j < branch.getCurrentSize()) {
                    this.queue.add(branch.getVariable(j), branch.getIndex(j));
                    ++j;
                }
                ++cpt;
                this.branches[i] = this.branches[this.nbBranches - 1];
                this.branches[this.nbBranches - 1] = branch;
                branch.clear();
                --this.nbBranches;
                --i;
            }
            ++i;
        }
    }

    protected boolean manageInconsistentAssignment(Variable variable, int index) {
        variable.getDomain().removeElementAt(index);
        ++this.nbEffectiveSingletonTests;
        if (variable.getCurrentDomainSize() == 0) {
            this.queue.clear();
            this.culprit = variable;
            return false;
        }
        this.updateBranchesAfterRemovalOf(variable, index);
        if (!this.mustMaintainAC) {
            this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        } else {
            int i = 0;
            while (i < this.sizes.length) {
                this.sizes[i] = this.solver.getVariable(i).getCurrentDomainSize();
                ++i;
            }
            assert (this.propagationSet.controlClear());
            boolean consistent = super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1);
            if (!consistent) {
                this.queue.clear();
                return false;
            }
            int i2 = 0;
            while (i2 < this.sizes.length) {
                Variable currentVariable = this.solver.getVariable(i2);
                int nbRemovals = this.sizes[i2] - currentVariable.getCurrentDomainSize();
                if (nbRemovals > 0) {
                    Elements elements = currentVariable.getDomain().getElements();
                    int j = 0;
                    int currentIndex = elements.getLastAbsent();
                    while (j < nbRemovals) {
                        this.updateBranchesAfterRemovalOf(currentVariable, currentIndex);
                        ++j;
                        currentIndex = elements.getPrevAbsent(currentIndex);
                    }
                }
                ++i2;
            }
        }
        return true;
    }

    protected boolean canTryAnotherExtensionInsteadOf(Variable variable, int index) {
        return false;
    }

    protected void dealWithNewBranch(Branch branch) {
        ((ExtendedBranch)branch).recordProblemDomain();
        this.undoAssignmentsFromBranch(branch);
        ++this.nbBranches;
        this.cumulBranchSizes += branch.getCurrentSize();
        ++this.nbBuiltBranches;
    }

    private ExtendedBranch getBranch(int i) {
        if (this.branches[i] == null) {
            this.branches[i] = new ExtendedBranch(this.solver);
        }
        return this.branches[i];
    }

    /*
     * Unable to fully structure code
     */
    protected boolean filterBySAC() {
        this.inferenceManager.removeInferences();
        this.nbBranches = 0;
        this.queue.fill();
        ** GOTO lbl16
        {
            if (!SingletonArcConsistency3Plus.$assertionsDisabled && !this.controlBranches()) {
                throw new AssertionError();
            }
            consistent = this.buildBranch(this.getBranch(this.nbBranches));
            if (!consistent) {
                return false;
            }
            if (this.solver.getResolution().isFinished()) {
                this.queue.clear();
                return true;
            }
            do {
                if (this.queue.size() > 0) continue block0;
                this.updateQueueFromInconsistentBranches();
lbl16:
                // 2 sources

            } while (this.queue.size() > 0);
        }
        System.out.println("nb = " + this.nbBuiltBranches + " sum = " + this.cumulBranchSizes + " avg =" + (this.nbBuiltBranches > 0 ? (double)this.cumulBranchSizes / (double)this.nbBuiltBranches : 0.0));
        if (!(SingletonArcConsistency3Plus.$assertionsDisabled || this.controlConsistency(false) && this.controlSingletonArcConsistency())) {
            throw new AssertionError();
        }
        return true;
    }

    private boolean controlBranches() {
        int i = 0;
        while (i < this.nbBranches) {
            if (!this.branches[i].controlWrt(this.queue)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

