/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.Branch;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnitFull;
import abscon.solvers.Solver;
import abscon.tools.elements.Elements;

public class ExtendedBranch
extends Branch {
    private InferenceUnitFull[] inferenceUnits;
    private boolean modified;
    private boolean inconsistent;

    public boolean isModified() {
        return this.modified;
    }

    public boolean isInconsistent() {
        return this.inconsistent;
    }

    public InferenceUnitFull getInferenceUnit(int i) {
        return this.inferenceUnits[i];
    }

    public ExtendedBranch(Solver solver) {
        super(solver);
        this.inferenceUnits = new InferenceUnitFull[solver.getNbVariables()];
    }

    public void recordProblemDomain() {
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < variables.length) {
            assert (variables[i].getCurrentDomainSize() > 0);
            if (!variables[i].isAssigned()) {
                Elements elements = variables[i].getDomain().getElements();
                if (this.inferenceUnits[i] == null) {
                    this.inferenceUnits[i] = new InferenceUnitFull(elements.getMaximumSize());
                }
                this.inferenceUnits[i].copy(elements.getAbsentLevels());
                this.inferenceUnits[i].setModified(false);
            }
            ++i;
        }
        this.modified = false;
        assert (this.controlModified());
    }

    public void updateAfterRemovalOf(Variable variable, int index) {
        if (this.has(variable)) {
            if (this.indexes[this.positions[variable.getId()]] == index) {
                this.modified = true;
                this.inconsistent = true;
            }
        } else if (!this.inferenceUnits[variable.getId()].isAbsent(index)) {
            this.inferenceUnits[variable.getId()].addAbsent(index);
            this.modified = true;
        }
        assert (this.controlModified());
    }

    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.inferenceUnits.length) {
            if (this.inferenceUnits[i] != null) {
                this.inferenceUnits[i].setModified(false);
            }
            ++i;
        }
        this.modified = false;
        this.inconsistent = false;
    }

    public boolean controlModified() {
        boolean b = false;
        int i = 0;
        while (!b && i < this.inferenceUnits.length) {
            if (this.positions[i] == -1 && this.inferenceUnits[i] != null && this.inferenceUnits[i].isModified()) {
                b = true;
            }
            ++i;
        }
        if (b && !this.modified) {
            System.out.println("modified = " + this.modified + " b= " + b);
        }
        return !b || this.modified;
    }
}

